/*  
 * 
 * KB_Bomber.m	-- An actor for controlling the bomber.  Responsible for the
 *                 bombs that it drops.
 * 
 * 
 * You may freely copy, distribute, and reuse the code in this example.
 * The author disclaims any warranty of any kind, expressed or implied, as to
 * its fitness for any particular use.
 *
 * Written by Mark G. Tacchi, mtacchi@next.com
 *
 * Wed Jul 27 1994
 */

#import "ActorMgr.h"
#import "KB_Bomber.h"
#import "KB_Bomb.h"
#import "KaBLAM.h"
#import "KaBLAMDefs.h"
#import "SoundMgr.h"
#import "Actor.h"

#define BOMBWIDTH 25
#define EXPLOSION_DELAY 150

@implementation KB_Bomber
- activate:sender :(int)tag
{
  NSSize	tsize= {65,72};
  NSSize	tsizeByTwo= {32.5,36};
  
  [super activate:sender :tag];
  [self reinitWithImage:@"kb_bomber"
		frameSize:&tsize
		numFrames:1
		shape: RECT
		alliance: EVIL
		radius: 0.0
		buffered: YES
		x: 0.0
		y:0.0
		theta: 0.0
		vel: 0.0
		interval: 200
		distToCorner: &tsizeByTwo];

  currentLevel= [scoreTaker level];
  [self setFrameOrigin:NSMakePoint(0.0, 134.)];
  
  //time before bomb drop (adjust for increasing level
  deltaTime= 500 -
    ((((float)currentLevel/2.==(int)(currentLevel/2)))?
    currentLevel*40 : (currentLevel-1)*40);
  if (deltaTime<200) deltaTime= 200;
  
  expireTime= timeInMS + deltaTime;		//time of first bomb drop
  explodeTimer= 0;		//used for delay between exploding bombs
  numBombs= 0;
  maxNumBombsForLevel= currentLevel*10; 
  xv= (randBetween(0,1)>0.5?-1:1)*(40 + currentLevel*3);
  explodeBombs= NO;
  stopped= NO;
  bombList= [[NSMutableArray allocWithZone:[self zone]] init];
  demoMode= [(KaBLAM *) scoreTaker demoMode];

  return self;
} /*activate::*/



- calcDxDy:(NSPoint *)dp
{
  
  //if at a boundary, bounce back; otherwise calc new pos
  if (x>(KB_SCREENWIDTH/2.0- frameSize.width - BOMBWIDTH)) {
    xv= -xv;
	[self setFrameOrigin:NSMakePoint(KB_SCREENWIDTH/2.0- frameSize.width - BOMBWIDTH - 1, y)];
  }
  else if (x<(-KB_SCREENWIDTH/2.0+ frameSize.width/2.0 + BOMBWIDTH)) {
    xv= -xv;
	[self setFrameOrigin:NSMakePoint(-KB_SCREENWIDTH/2.0+ frameSize.width/2.0 + BOMBWIDTH  + 1, y)];
  }
  else {
    if (explodeBombs) {		//bombs are exploding
	  if (timeInMS > explodeTimer) {
	    id  currentBomb= [bombList objectAtIndex:0];
	    if (currentBomb!=nil) {
		  [bombList removeObjectAtIndex:0];
          [currentBomb perform: @selector(explode)];
		  explodeTimer= timeInMS + EXPLOSION_DELAY;
	    }
		else {
			    explodeBombs= NO;
	            [scoreTaker setPauseForNextLevel:YES];
        }
	  }
	}
	else {
      dp->x= timeScale * xv;
	}
  }  
  return self;
} /*calcDxDy:*/



- positionChanged
{
  if (timeInMS > expireTime && !stopped) {
    [self dropBomb];
  }

  [super positionChanged];
  return self;
} /*positionChanged*/



//bomb was dropped, or end of wave
- stop
{
  stopped= YES;
  xv= 0;
  
  return self;
} /*stop*/



- dropBomb
{
  id myBomb;

  expireTime= timeInMS + deltaTime;		//time of next bomb drop
  
  myBomb=[actorMgr newActor:kb_bomb for:scoreTaker tag:numBombs++];
  [[(KB_Bomb *) myBomb setOwner: self] setPosition: x + frameSize.width/2.0] ;
  
  [bombList addObject: myBomb];
  
  if (numBombs>=maxNumBombsForLevel)
    if (!demoMode) {  //only pause if not in demo mode
      [scoreTaker setPauseForNextLevel:YES];
	  [self stop];
    }
  frame= 1;  //make it look like he is tossing the bomb
  
  return self;
} /*dropBomb*/



//this is called by the bomb that has hit the bottom first.
- explodeAllBombs
{
  explodeBombs= YES;
  [bombList makeObjectsPerformSelector: @selector(stop)];
  [self stop];
  [scoreTaker loseLife];
  
  return self;
} /*explodeAllBombs*/



- removeLowestBombFromList
{
  [bombList removeObjectAtIndex:0];
  
  return self;
} /*removeLowestBombFromList*/


- (NSMutableArray *) bombList
{
  return bombList;
}
@end
