/*  
 * 
 * KB_Bomb.m	-- An actor for controlling the bombs.  Responsible for
 *                 notifying the bomber when it has dropped.
 * 
 * 
 * You may freely copy, distribute, and reuse the code in this example.
 * The author disclaims any warranty of any kind, expressed or implied, as to
 * its fitness for any particular use.
 *
 * Written by Mark G. Tacchi, mtacchi@next.com
 *
 * Wed Jul 27 1994
 */

#import "ActorMgr.h"
#import "KB_Bomb.h"
#import "KB_Bomber.h"
#import "KaBLAMDefs.h"
#import "KaBLAM.h"
#import "SoundMgr.h"
#import "Actor.h"

@implementation KB_Bomb
- activate:sender :(int)tag
{
  NSSize tsize= {25,36};
  NSSize tsizeByTwo= {12.5,18};
    
  [super activate:sender :tag];
  [self reinitWithImage:@"kb_bomb"
		frameSize:&tsize
		numFrames:2
		shape: RECT
		alliance: EVIL
		radius: 0.0
		buffered: YES
		x: 0.0
		y: 100.0
		theta: 0.0
		vel: 0.0
		interval: 100
		distToCorner: &tsizeByTwo];

  yv= -8 - [(KaBLAM *)scoreTaker level] * 2;
  xv=0;
  demoMode= [(KaBLAM *) scoreTaker demoMode];
  return self;
} /*activate::*/




- calcDxDy:(NSPoint *)dp
{
  dp->y= timeScale * yv;
  dp->x= 0;
  xv=0;
  
  return self;
} /*calcDxDy:*/



- positionChanged
{
  if (y<(-KB_SCREENHEIGHT/2.0 + frameSize.height/2.0)) {
    [self setFrameOrigin:NSMakePoint(x, -KB_SCREENHEIGHT/2.0 + frameSize.height/2.0 + 2)];
    if (!demoMode) [(KB_Bomber *) bomber explodeAllBombs];
	else [self explode];
  } /*endif*/

  [super positionChanged];
  return self;
} /*positionChanged*/



- setPosition: (const float) newX
{
  float myX= newX;
  
  //let's be sure that the bomb is really in view
  //(bomber sometime has tendency to overshoot)
  if (myX>(KB_SCREENWIDTH/2.0 - frameSize.width/2.0))
    myX= KB_SCREENWIDTH/2.0 - frameSize.width/2.0;
  else if (myX<(-KB_SCREENWIDTH/2.0 + frameSize.width/2.0))
    myX= -KB_SCREENWIDTH/2.0 + frameSize.width/2.0;
	
  [self setFrameOrigin:NSMakePoint(myX, y)];
  
  return self;
} /*setPosition:*/



- (float) position { return x; }



//KB_Bomber is responsible for exploding each bomb
- explode
{
  if (!demoMode) {	
    [actorMgr newActor:xx_explosion for:self tag:1];
    [soundMgr playSound: kb_explodeSnd at:0.5];
  }
  else		//should quietly die if in demo mode
    [(KB_Bomber *) bomber removeLowestBombFromList];
  
  [actorMgr destroyActor:self];
 
 return self;
} /*explode*/



- setOwner: sender
{
  bomber= sender;
  
  return self;
} /*setOwner:*/



- stop
{
  yv= 0;
  
  return self;
} /*stop*/



- performCollisionWith:(Actor *) theActor
{
  if (theActor->actorType == kb_player) {
	
    if (y>(-KB_SCREENHEIGHT/2.0 + frameSize.height/2.0)) {
      int sndForLevel= [(KaBLAM *)scoreTaker level] - 2;

	  if (sndForLevel>7) sndForLevel= 7;
	  [(KaBLAM *)scoreTaker addScore: [(KaBLAM *)scoreTaker level] - 1];
      if (!demoMode) [soundMgr playSound: kb_catchSnd[sndForLevel] at:0.5];
      [(KB_Bomber *) bomber removeLowestBombFromList];
      [actorMgr destroyActor:self];
	} /*endif*/
  } /*endif*/
	
  return self;
} /*performCollisionWith:*/
@end
