#import <AppKit/AppKit.h>
#import "BackView.h"

@interface BackView(KB_BackView)
- (void)resetCursorRects;
@end

@implementation BackView(KB_BackView)
- (BOOL)acceptsFirstMouse:(NSEvent *)theEvent
{
    return YES;
} /*acceptsFirstMouse*/



- (void)resetCursorRects
{
  NSRect visible;
  NSPoint noPoint={0,0};
  // If there's a visible rect, make the cursor be our
  // "blank" cursor whenever it's above our view.
  if (!NSIsEmptyRect(visible = [self visibleRect])) {
    NSImage *theImage = [NSImage imageNamed:@"kb_emptyCursor"];
    NSCursor *theCursor=[[NSCursor alloc] initWithImage:theImage hotSpot:noPoint];
    [self addCursorRect:visible cursor:theCursor];
  }
} /*resetCursorRects*/

@end
