
#import "DisplayManager.h"
#import "CacheManager.h"
#import "Thinker.h"
#import "xoxDefs.h"

@implementation DisplayManager

- init
{
	[super init];

	eraseList = [[SimpleStorage allocWithZone:[self zone]]
		initCount:8
		elementSize: sizeof(NSRect)
		description: @encode(NSRect)];
        whiteList = [[SimpleStorage allocWithZone:[self zone]]
		initCount:8
		elementSize: sizeof(NSRect)
		description: @encode(NSRect)];
	drawList = [[NSMutableArray allocWithZone:[self zone]] init];

	return self;
}

- oneStep
{
	if ([eraseList count])
	{
		PSsetgray(NSBlack);
		NSRectFillList(eraseList->dataPtr, eraseList->numElements);
		[eraseList removeAllObjects];
	}

	[drawList performInOrder:@selector(draw)];
	[drawList removeAllObjects];

	if ([whiteList count])
	{
		PSsetgray(NSWhite);
		NSRectFillList(whiteList->dataPtr, whiteList->numElements);
		[whiteList removeAllObjects];
	}
	return self;
}

- erase:(NSRect *)r
{
	// it looks best if we erase by drawing from the cache
	[cacheMgr displayRect:*r];
	return self;
}

- (void)displayRect:(NSRect )r
{
	// it looks best if we erase by drawing from the cache
	[cacheMgr displayRect:r];
}

- drawWhiteRect:(NSRect *)r
{
	[whiteList addElement:r];
	return self;
}

- draw:sender;
{
	[drawList addObject:sender];
	return self;
}


@end
