
#import "DF_People.h"
#import "DF_Alien.h"
#import "ActorMgr.h"
#import "SoundMgr.h"
#import "Defender.h"
#import "Thinker.h"

@implementation DF_People

+ (void)initialize
{
	[super initialize];
	[[NSApp delegate] addImageResource:"dflittlepeople" for: self];
	return;
}

- activate:sender :(int)tag
{
	NSSize tsize = {14,17};
	NSSize tsize2 = {7,8.5};

	[super activate:sender :tag];

	[self reinitWithImage:@"dflittlepeople"
		frameSize:&tsize
		numFrames:4
		shape: RECTCIRC
		alliance: GOOD
		radius: tsize2.width
		buffered: YES
		x: randBetween(0, 3500)
		y: -yOffset + distToCorner.height
		theta: randBetween(0,2*PI)
		vel: randBetween(2,12)
		interval: randBetween(20,80)
		distToCorner: &tsize2];

	dirInterval = randBetween(2000,10000);
	directionTime = timeInMS + dirInterval;
	frameDir = 1;
	return self;
}

extern float df_heightAt(float x);

- positionChanged
{
	float max_ht;

	if (timeInMS > changeTime)
	{
		changeTime = timeInMS + interval;
		frame += frameDir;
		if (frame >= numFrames-1) frameDir = -1;
		else if (frame <= 0) frameDir = 1;
	}

	if (timeInMS > directionTime)
	{
		directionTime = timeInMS + dirInterval;
		xv = randBetween(-7, 7);
		yv = randBetween(-6, 6);
	}

	[self wrapAtDistance: (1500) :(yOffset+1000)];

	if (y < -yOffset + distToCorner.height)
		[self setFrameOrigin:NSMakePoint(x, -yOffset + distToCorner.height)];
	else if (y > (max_ht =  (-yOffset + distToCorner.height + df_heightAt(x))))
		[self setFrameOrigin:NSMakePoint(x, max_ht)];

	return self;
}

- performCollisionWith:(Actor *) dude
{
	id ret = self;
	if (dude->actorType == (int)[DF_Laser class])
	{
		[actorMgr newActor:xx_explosion for:self tag:1];
		ret = [super performCollisionWith: dude];
	}
	return ret;
}


@end
