
#import "DF_Alien.h"
#import "DF_People.h"
#import "ActorMgr.h"
#import "SoundMgr.h"
#import "Defender.h"
#import "Thinker.h"

@implementation DF_Alien

+ (void)initialize
{
	[super initialize];
	[[NSApp delegate] addImageResource:"dfaliens" for: self];
	return;
}

- activate:sender :(int)tag
{
	NSSize tsize = {35,35};
	NSSize tsize2 = {17.5,17.5};

	[super activate:sender :tag];

	[self reinitWithImage:@"dfaliens"
		frameSize:&tsize
		numFrames:2
		shape: RECTCIRC
		alliance: EVIL
		radius: tsize2.width
		buffered: YES
		x: randBetween(xOffset, 3000-xOffset)
		y: randBetween(-yOffset, yOffset)
		theta: randBetween(0,2*PI)
		vel: randBetween(2,12)
		interval: randBetween(250,325)
		distToCorner: &tsize2];

	return self;
}

- positionChanged
{
	[super positionChanged];
	[self wrapAtDistance: (1500) :(yOffset+18)];
	return self;
}

- performCollisionWith:(Actor *) dude
{
	if (dude->actorType == (int)[DF_People class]) return self;
	[actorMgr newActor:xx_explosion for:self tag:1];
	return [super performCollisionWith: dude];
}


@end


@implementation DF_Laser

+ (void)initialize
{
	[super initialize];
	[[NSApp delegate] addImageResource:"dflaser" for: self];
	return;
}

- activate:sender :(int)tag
{
	Actor *dude = (Actor *)sender;
	NSSize tsize = {80,3};
	NSSize tsize2 = {40,1.5};

	[super activate:sender :tag];

	[self reinitWithImage:@"dflaser"
		frameSize:&tsize
		numFrames:8
		shape: RECT
		alliance: DESTROYALL
		radius: tsize2.width
		buffered: NO
		x: dude->x
		y: dude->y
		theta: dude->theta
		vel:0
		interval: 80
		distToCorner: &tsize2];

	xv = dude->xv + ((dude->theta < 0)? 62 : -62);
	yv = 0;

	frame = (theta < 0)? 0 : 4;

	expireTime = timeInMS + 1500;
	[soundMgr playSound: BULLET1SND at:0.5];

	return self;
}

- positionChanged
{
	if (timeInMS > changeTime)
	{
		changeTime = timeInMS + interval;
		if (theta > 0)
		{
			if (++frame > 7) frame = 4;
		}
		else
		{	if (++frame > 3) frame = 0;
		}
	}
	return self;
}

- calcDxDy:(NSPoint *)dp
{
	if (timeInMS > expireTime)
		[actorMgr destroyActor:self];

	dp->x = timeScale * xv;
	dp->y = timeScale * yv;

	return self;
}



@end
