/*
    File:       CalcController.m

    Contains:   xxx

    Written by: Andy Wildenberg

    Created:    Wed 09-Jul-1997

    Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

    Change History (most recent first):

        9 July 97 -- first version of application
 
    You may incorporate this sample code into your applications without
    restriction, though the sample code has been provided "AS IS" and the
    responsibility for its operation is 100% yours.  However, what you are
    not permitted to do is to redistribute the source as "DSC Sample Code"
    after having made changes. If you're going to re-distribute the source,
    we require that you make it clear in the source that the code was
    descended from Apple Sample Code, but that you've made changes.
*/

#import "CalcController.h"

@implementation CalcController

- (void)clear:(id)sender
{
    [displayedNumber autorelease];
    displayedNumber = [[NSDecimalNumber zero] retain];
    [enteredNumber autorelease];
    enteredNumber = [[NSDecimalNumber zero] retain];
    [displayView setDoubleValue: 0];
    [self endEditingNumber];
    lastOperation = kNoOperator;
    usedDecimalPoint = NO;
}

- (void)equals:(id)sender
{
    if (enteringNumber)
      {
        [self endEditingNumber];
        [self performLastOperation];
        lastOperation = kNoOperator;
        [displayView setStringValue: [displayedNumber stringValue]];
      }
}

- (void)insertDigit:(id)sender
{
    NSString* oldValue;

    if (!enteringNumber)
      {
        [self beginEditingNumber];
      }


    oldValue = [displayView stringValue];
    [displayView setStringValue: [oldValue stringByAppendingString: [sender title]]];
}

- (void)beginEditingNumber
{
    enteringNumber = YES;
    usedDecimalPoint = NO;
    [displayView setStringValue: @""];
    [enteredNumber autorelease];
    enteredNumber = [displayedNumber copy]; 
}

- (void)endEditingNumber
{
    enteringNumber = NO;
    usedDecimalPoint = NO;

    [displayedNumber autorelease];
    displayedNumber = [NSDecimalNumber decimalNumberWithString: [displayView stringValue]];
    [displayedNumber retain];
}

- (void)decimalPoint:(id)sender
{
    NSString* oldValue;

    if (!usedDecimalPoint)
      {
        usedDecimalPoint = YES;
        if (!enteringNumber)
          {
            [self beginEditingNumber];
            [displayView setStringValue: @"0."];
          }
        else
          {
            oldValue = [displayView stringValue];
            [displayView setStringValue: [oldValue stringByAppendingString: @"."]];
          }
      }
}

-(void) awakeFromNib
{
    [self clear: self];
    [[displayView window] makeKeyAndOrderFront:nil];
}

- (void)operation:(id)sender
{
    if (enteringNumber)
      {
        [self endEditingNumber];
        [self performLastOperation];
        [displayView setStringValue: [displayedNumber stringValue]];
      }
    // no matter what, set the new operation in case the user changes his/her mind
    lastOperation = [sender tag];

}

- (void)performLastOperation
{
    if (lastOperation == kNoOperator) return;
    
    // This way of detecting NANs is a HACK!  Unfortunately, NaN is not ordered, so
    // if you ask any number if it's equal to NaN, it'll say yes.  So, instead we'll
    // ask if it's equal to an impossible combination of numbers -- zero and one.
    // The only 'number' equal to both is NaN

    [displayedNumber autorelease];
    
    if ((([displayedNumber compare: [NSDecimalNumber zero]] == NSOrderedSame) &&
         ([displayedNumber compare: [NSDecimalNumber one]] == NSOrderedSame)) ||
        (([enteredNumber compare: [NSDecimalNumber zero]] == NSOrderedSame) &&
         ([enteredNumber compare: [NSDecimalNumber one]] == NSOrderedSame)))
      {
        displayedNumber = [NSDecimalNumber notANumber];
      }
    else
      {
        NS_DURING
            switch(lastOperation)
              {
                case kAddOperator:      displayedNumber = [enteredNumber decimalNumberByAdding: displayedNumber]; break;
                case kSubtractOperator: displayedNumber = [enteredNumber decimalNumberBySubtracting: displayedNumber]; break;
                case kMultiplyOperator: displayedNumber = [enteredNumber decimalNumberByMultiplyingBy: displayedNumber]; break;
                case kDivideOperator:   displayedNumber = [enteredNumber decimalNumberByDividingBy: displayedNumber]; break;
              };
        NS_HANDLER
          {
              // if get here, we either got a divide by zero, or an over/under flow exception
              // in any case, we return NAN
              displayedNumber = [NSDecimalNumber notANumber];
          };
        NS_ENDHANDLER
      }

    [displayedNumber retain];
}

- (BOOL)applicationShouldTerminateAfterLastWindowClosed:(NSApplication *)theApplication
{
    return YES;
}

- (void)cut:(id)sender
{
    [self copy: self];
    [self clear: self];
}

- (void)copy:(id)sender
{
    NSPasteboard* pasteboard = [NSPasteboard generalPasteboard];
    [pasteboard declareTypes: [NSArray arrayWithObject: NSStringPboardType] owner: NULL];
    [pasteboard setString: [displayView stringValue] forType: NSStringPboardType];
}

- (void)paste:(id)sender
{
    NSPasteboard* pasteboard;
    NSString* pasteValue;

    if (!enteringNumber)
      {
        [self beginEditingNumber];
      }

    pasteboard = [NSPasteboard generalPasteboard];
    pasteValue = [pasteboard stringForType: NSStringPboardType];
    [displayView setStringValue: [[displayView stringValue] stringByAppendingString: pasteValue]];
}

// when self is released, it is necessary to release all of the variables we've retained
-(void)dealloc
{
    [displayedNumber release];
    [enteredNumber release];
}

@end
