/* -*-ObjC-*-
*******************************************************************************
*
* File:         nextmail.m
* RCS:          /usr/local/sources/CVS/mailapp-utilities/nextmail.m,v 1.18 1998/11/21 17:35:59 tom Exp
* Description:  A 'mail' compatible program to open a Mail.app Compose window
* Author:       Carl Edman
* Created:      Thu Mar  4 13:42:52 1993
* Modified:     Fri Feb 13 20:05:47 1998 Tom Hageman <tom@basil.icce.rug.nl>
* Language:     Objective C
* Package:      mailapp-utilities
* Status:       Experimental
*
* (C) Copyright 1993-1998, but otherwise this file is perfect freeware.
*
*******************************************************************************
*/

#import <libc.h>
//#import <stdlib.h>
//#import <stdio.h>
#import "compat.h"
#import "MailProxy.h"
#import "mailutil.h"
#import "optutil.h"

#if NEXTSTEP
#  define NXHOST  "NXHost"
#else
#  define NXHOST  "NSHost"

#endif

#if NEXTSTEP || OPENSTEP
#   define USAGE_NXHOST	"[-h|-"NXHOST" host] "
#   define HELP_NXHOST	"\
 -"NXHOST" host,\n\
 -h host       connect to Mailer on given host\n"
#   define DREAD	"dread -g"
#  define BCC_MAY_BE_UNSUPPORTED "\
                 (NB. Some mailers, like Mail.app, do not support this.)\n"   
#else
#   define USAGE_NXHOST
#   define HELP_NXHOST
#   define DREAD	"defaults read NSGlobalDomain"
#  define BCC_MAY_BE_UNSUPPORTED
#endif

#define USAGE "\
Usage: %s [-v] [-de] [-s subject] [-cb user ...] [-m mailer]\n\
              "USAGE_NXHOST"[-V|-H] [user ...]\n"

#define HELP "\
 -v            talkative mode\n\
 -d            deliver message immediately (default if invoked as \"nextmail\")\n\
 -e            edit message in Compose window (default if invoked as \"mailto\")\n\
 -s subject    set Subject: to `subject'\n\
 -c user       cc: to `user' (allowed multiple times)\n\
 -b user       bcc: to `user' (allowed multiple times)\n\
"BCC_MAY_BE_UNSUPPORTED"\
"HELP_NXHOST"\
 -m mailer     use `mailer' instead of default\n\
                 (\""DREAD" Mailer\", or "MAIL_APP".app)\n\
 -V,--version  show version\n\
 -H,--help     this help\n\
"

#define EXIT(status) \
   POOL_RELEASE \
   return(status)

int main(int ac,char *av[])
{
   Class mailProxyClass;
   MailProxy *mailProxy;
   char *to=0,*subject=0,*cc=0,*bcc=0,*content=0;
   const char *mailer=0;
   int tolen=0,subjectlen=0,cclen=0,bcclen=0,contentlen=0;
   int tomaxlen=0,subjectmaxlen=0,ccmaxlen=0,bccmaxlen=0,contentmaxlen=0;
   int deliverflg=0,verbose=0,c,i;
   char *host="";
   int status=EXIT_SUCCESS;
   POOL_INIT

   set_progname(av[0]);

   /* Default to Deliver mode if we are invoked as "nextmail",
      and to Edit aka Compose mode otherwise. */
   if (strncmp("nextmail", progname(), 8) == 0) deliverflg=1;

   for (;;)
   {
      switch ((c=getopt(ac,av,"s:c:b:m:deN:h:vVH")))
      {
       case 's':
	 if (subject) appstring(&subject,&subjectlen,&subjectmaxlen," ",1);
	 appstring(&subject,&subjectlen,&subjectmaxlen,optarg,strlen(optarg));
	 continue;
       case 'c':
	 if (cc) appstring(&cc,&cclen,&ccmaxlen,",",1);
	 appstring(&cc,&cclen,&ccmaxlen,optarg,strlen(optarg));
	 continue;
       case 'b':
	 if (bcc) appstring(&bcc,&bcclen,&bccmaxlen,",",1);
	 appstring(&bcc,&bcclen,&bccmaxlen,optarg,strlen(optarg));
	 continue;
       case 'm':
	 mailer=optarg;
	 continue;
       case 'd':
	 deliverflg++;
	 continue;
       case 'e':
	 deliverflg=0;
	 continue;
       case 'N':
	 if ((strcmp(av[optind-1], "-NXHost") == 0 ||
	      strcmp(av[optind-1], "-NSHost") == 0) && (optind < ac))
	 {
	    host=av[optind++];
	    continue;
	 }
	 status=EXIT_USAGE;
	 break;
       case 'h':
	 host=optarg;
	 continue;
       case 'v':
	 verbose++;
	 continue;
       case 'V':
	 status=EXIT_VERSION;
	 break;
       case 'H':
	 status=EXIT_HELP;
	 break;
       case EOF:
	 status=check_arg_for_long_help_version(av[optind-1]);
	 break;
       case '?':
       default:
	 status=EXIT_USAGE;
	 break;
      }
      break;
   }
   handle_usage_help_version(status, USAGE, HELP);

   if (optind == ac) deliverflg = 0;

   mailProxyClass = [MailProxy classForMailer:mailer
			directDelivery:deliverflg incorporation:NO];

   if (!deliverflg && ![mailProxyClass canEditMessage])
   {
      logprintf("%s does not support [-e] editing",  mailProxyClass ? mailProxyClass->name : "MailProxy");
      EXIT(EXIT_USAGE);
   }
   if (bcclen > 0 && ![mailProxyClass canSendBcc])
   {
      logprintf("%s does not support Bcc:", mailProxyClass ? mailProxyClass->name : "MailProxy");
      EXIT(EXIT_USAGE);
   }

   for(;optind<ac;optind++)
   {
      if (to) appstring(&to,&tolen,&tomaxlen,",",1);
      appstring(&to,&tolen,&tomaxlen,av[optind],strlen(av[optind]));
   }

   mailProxy = [[mailProxyClass alloc] initForMailer:mailer host:host
		  forceLaunch:YES directDelivery:deliverflg];

   if (mailProxy == nil)
   {
      logprintf("unable to connect to %s.app on %s",
		(mailer && *mailer) ? mailer : [mailProxyClass defaultMailer],
		(host && *host) ? host : "localhost");
      EXIT(EXIT_FAILURE);
   }
   if (![mailProxy isConnected])
   {
      logprintf("unable to connect to %s.app on %s", [mailProxy mailer], [mailProxy host]);
      EXIT(EXIT_FAILURE);
   }

   while((i=fread(growstring(&content,&contentlen,&contentmaxlen,LINELEN*16),
                  1,LINELEN*16,stdin))>0)
   {
      contentlen+=i;
   }

   // zero-terminate strings:
   if (to)      appstring(&to,&tolen,&tomaxlen,"",1);
   if (subject) appstring(&subject,&subjectlen,&subjectmaxlen,"",1);
   if (cc)      appstring(&cc,&cclen,&ccmaxlen,"",1);
   if (bcc)     appstring(&bcc,&bcclen,&bccmaxlen,"",1);
   if (content) appstring(&content,&contentlen,&contentmaxlen,"",1);

   if (![mailProxy sendMailTo:to subject:subject body:content cc:cc bcc:bcc])
   {
      logprintf("unable to send message to %s.app on %s", [mailProxy mailer], [mailProxy host]);
      EXIT(EXIT_FAILURE);
   }
   
   [mailProxy release];

   EXIT(EXIT_SUCCESS);
}
