/* -*-C-*-
*******************************************************************************
*
* File:         iso_convert.h
* RCS:          iso_convert.h,v 1.3 1999/04/26 15:08:34 tom Exp
* Description:  some iso header conversions.
* Author:       Tom Hageman <tom@basil.icce.rug.nl>
* Created:      Tue Dec 16 18:15:26 1997 (extracted/expanded from appnmail)
* Modified:     
* Language:     C
* Package:      mailapp-utilities
* Status:       Exp.
*
* (C) Copyright 1997, but otherwise this file is perfect freeware.
*
*******************************************************************************
*/

#import "compat.h"

#define DEF_INPUT_ENCODING	"iso-8859-1"

#define NEXT_OUTPUT_ENCODING	"next"
#define MAC_OUTPUT_ENCODING	"mac"

#if RHAPSODY
#  define DEF_OUTPUT_ENCODING	MAC_OUTPUT_ENCODING
#else
#  define DEF_OUTPUT_ENCODING	NEXT_OUTPUT_ENCODING
#endif

size_t decode_quoted_printable(char *buf, const char *str, size_t len, int *err);
size_t decode_base64(char *buf, const char *str, size_t len, int *err);

int iso_convert(char *line, const char *input_encoding, const char *output_encoding);
   /* convert header line, in-place. return 0 if successful, -1 on failure. */
