//----------------------------------------------------------------------------------------------------
//
//	MailSpeaker
//
//	Inherits From:		Speaker
//
//	Declared In:		MailSpeaker.h
//
//	Class Description
//
//		MailSpeaker is a custom Speaker subclass that supports
//		remote messages implemented in Mail.app's custom Listener
//		subclass MailListener.  After setting its send port (via the method
//		"setSendPort: (port_t) aPort" ) to named port "MailSendDemo", 
//		you may message an instance of this class with one of the 
//		methods declared in this interface. It will in turn send Mail.app's 
//		MailListener instance the corresponding message (via a Mach 
//		message), which will be interpreted, and subsequently executed 
//		in Mail.app.
//
//		MailListener (and this class) support compose methods that both 
//		do and do not take a window number as an argument.  You can 
//		manage multiple compose windows by using those that do.  A
//		unique window number is returned by reference in the method
//		'openSend:'.  This is then used as the argument for methods that
//		take a window number.
//
//		Port information...  You should first set an instance's send port to
//		the named port "Mail".  This will launch Mail.app if not already.
//		Then, to perform the methods declared in this interface, set the 
//		send port to "MailSendDemo".
//		 
//		This class is generated by the Unix 'msgwrap' utility.  It has been 
//		reformatted for readability.  Mail.msg was the original file passed
//		to msgwrap.
//
//	Disclaimer
//
//		You may freely copy, distribute and reuse this software and its
//		associated documentation. I disclaim any warranty of any kind, 
//		expressed or implied, as to its fitness for any particular use.
//
//----------------------------------------------------------------------------------------------------

#import "compat.h"
#if NEXTSTEP

#  import <appkit/Speaker.h>
#  import <appkit/Listener.h>
#  define S_(string)  (string)

#elif OPENSTEP

#  warning Using obsolete Speaker/Listener classes.
#  import <AppKit/obsoleteSpeaker.h>
#  import <AppKit/obsoleteListener.h>
#  define S_(string)  [NSString stringWithCString:(string)]
#  define NXPortFromName(port,host) NXPortFromName(S_(port), S_(host)) 
#  define NXPortNameLookup(port,host) NXPortNameLookup(S_(port), S_(host)) 

#elif RHAPSODY

#  error No MailSpeaker equivalent for Rhapsody.

#else
#  error unknown NEXTSTEP/OPENSTEP version.
#endif

#define MAILSEND_PORTNAME  "MailSendDemo"


@interface MailSpeaker : Speaker
{
}

- (int)incorporateNewMail;

//----------------------------------------------------------------------------------------------------
//  Compose Methods (window not specified)
//----------------------------------------------------------------------------------------------------
- (int)deliver;
- (int)openSend;
- (int)setBody:(const char *)aString;
- (int)setCc:(const char *)aString;
- (int)setSubject:(const char *)aString;
- (int)setTo:(const char *)aString;

//----------------------------------------------------------------------------------------------------
//  Compose Methods (window specified)
//----------------------------------------------------------------------------------------------------
- (int)deliver:(int)aWindow;
- (int)openSend:(int *)aWindow;
- (int)setBody:(const char *)aString inWindow:(int)aWindow;
- (int)setCc:(const char *)aString inWindow:(int)aWindow;
- (int)setSubject:(const char *)aString inWindow:(int)aWindow;
- (int)setTo:(const char *)aString inWindow:(int)aWindow;

@end // MailSpeaker
