/*+++
 *  title:      MailAppProxy.m
 *  abstract:   Implementation of MailAppProxy class for mailapp-utilities.
 *  author:     Tom Hageman <tom@basil.icce.rug.nl>
 *  created:    October 1998
 *  modified:   
 *  copyleft:
 *
 *	Copyright (C) 1998  Tom R. Hageman, but otherwise perfect freeware.
 *
 *  description:
 *
 *      Private concrete MailProxy subclass.
 *	Implements communication with Mail.app (and other mail clients that
 *	implement the MailSendDemo Listener protocol on NEXTSTEP / OPENSTEP.)
 *	
 *---*/

static const char * const RCSid = ((void)&RCSid,
	"@(#)MailAppProxy.m,v 1.4 1998/12/02 00:27:51 tom Exp");
#define RCS_MailAppProxy_ID

#import "MailProxy.h"
#import "MailSpeaker.h"
#import "mailutil.h"
#import <stdlib.h>
#import <mach/mach.h>

#if RHAPSODY
 #error Mail.app Proxy not supported on Rhapsody.
#endif


@interface MailAppProxy : MailProxy
{
   MailSpeaker *mailSpeaker;
}

@end // MailAppProxy


@implementation MailAppProxy

+ (BOOL)canEditMessage		{ return YES; }
+ (BOOL)canDeliverMessage	{ return YES; }
+ (BOOL)canIncorporateNewMail	{ return YES; }
//+ (BOOL)canSendBcc		{ return NO; }
//+ (BOOL)canSendArbitraryHeaders  { return NO; }


#if NEXTSTEP
- free
{
   [mailSpeaker free];
   return [super free];
}
#else
- (void)dealloc
{
   [mailSpeaker release];
   [super dealloc];
}
#endif


- (BOOL)connectToMailer
{
   port_t mailPort;

   mailPort = NXPortNameLookup(MAILSEND_PORTNAME, hostname);

   if (mailPort == PORT_NULL) return NO;

   mailSpeaker = [[MailSpeaker alloc] init];

   [mailSpeaker setSendPort:mailPort];
   return YES;
}

- (BOOL)retryConnectToMailer
{
   if (strcmp(mailer, MAIL_APP) != 0)
   {
      // surreptitiously switch mailer to system mailer.
      char *orgMailer = mailer;

      mailer = MAIL_APP;

      if ([self launchMailer] && [self connectToMailer])
      {
	 // System mailer could be contacted.  Huzzah!
	 free(orgMailer);
	 mailer = NXCopyStringBufferFromZone(mailer, [self zone]);
	 return YES;
      }

      // Failed to launch or connect, so restore old situation.
      mailer = orgMailer;
   }
   return NO;
}


- (BOOL)sendMailTo:(const char *)to
   subject:(const char *)subject
   body:(const char *)body
   cc:(const char *)cc
   bcc:(const char *)bcc
{
   int status = 0;
   int window;

   if ([mailSpeaker openSend:&window] != 0) return NO;

   if (to)	status |= [mailSpeaker setTo:to		  inWindow:window];
   if (subject)	status |= [mailSpeaker setSubject:subject inWindow:window];
   if (cc)	status |= [mailSpeaker setCc:cc		  inWindow:window];
   if (body)	status |= [mailSpeaker setBody:body	  inWindow:window];

   if (deliver && to && (subject || body))
   {
      status |= [mailSpeaker deliver:window];
   }
   else
   {
      [self makeMailerActive];
   }
   return (status == 0);
}


- (BOOL)incorporateNewMail
{
   return [mailSpeaker incorporateNewMail] == 0;
}


#if !NEXTSTEP

- (BOOL)sendMailMessageTo:(NSString *)to
   subject:(NSString *)subject
   body:(id)body
   cc:(NSString *)cc
   bcc:(NSString *)bcc
{
   return [self sendMailTo:[to cString]
		subject:[subject cString]
		body:[[self replacementObjectForBody:body] cString]
		cc:[cc cString]
		bcc:[bcc cString]];
}

#endif // !NEXTSTEP

@end // MailAppProxy
