#ifndef __MiscTableScroll_NSIBConnector_h
#define __MiscTableScroll_NSIBConnector_h
//=============================================================================
//
//		Copyright (C) 1995-1997 NeXT Software, Inc.
//			    All Rights Reserved.
//	
//=============================================================================
//-----------------------------------------------------------------------------
// NSIBConnector.h
//
//	The declarations of Interface Builder's private connection classes:
//	NSIBConnector, NSIBOutletConnector, and NSIBControlConnector.
//
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: NSIBConnector.h,v 1.3 97/06/18 09:53:53 sunshine Exp $
// $Log:	NSIBConnector.h,v $
//  Revision 1.3  97/06/18  09:53:53  sunshine
//  v125.9: Renamed: IBConnector.h --> NSIBConnector.h.  Commented & updated.
//  
//-----------------------------------------------------------------------------
extern "Objective-C" {
#import	<Foundation/NSObject.h>
}

@interface NSIBConnector : NSObject<IBConnectors>
    {
    id source;
    id destination;
    NSString* label;
    }

- (id)initWithCoder:(NSCoder*)coder;
- (void)encodeWithCoder:(NSCoder*)coder;

- (id)source;
- (void)setSource:(id)src;
- (id)destination;
- (void)setDestination:(id)dest;
- (NSString*)label;
- (void)setLabel:(NSString*)label;
- (void)replaceObject:(id)oldObject withObject:(id)newObject;
- (id)nibInstantiate;
- (void)establishConnection;

- (NSString*)nibLabel;
- (void)displayConnection;

@end

@interface NSIBOutletConnector : NSIBConnector
- (void)establishConnection;
@end

@interface NSIBControlConnector : NSIBConnector
- (NSString*)nibLabel;
- (void)establishConnection;
@end

#endif // __MiscTableScroll_NSIBConnector_h
