/*************************************************************************
 * File Name: NSDictionary+MiscDefaultsSupport.h
 * Version  : 0.0 alpha
 * Date     : Thu 21-Aug-1997
 *************************************************************************
 *  COPYWHAT (C) 1997 by Tomi Engel
 *
 * This notice may not be removed from this source code.
 * The use and distribution of this software is governed by the
 * terms of the MiscKit license agreement.  Refer to the license
 * document included with the MiscKit distribution for the terms.
 *                    ALL RIGHTS RESERVED
 *
 *************************************************************************    
 * Notes      : 
 * Bugs       : 
 * Author(s)  : tsengel
 * Last update: $Date: 1997/08/27 11:02:57 $
 * History    : $Log: NSDictionary+MiscDefaultsSupport.h,v $
 * History    : Revision 1.1  1997/08/27 11:02:57  tsengel
 * History    : Added to the FBAuthor repository
 * History    :
 * History    : Revision 1.1  1997/08/22 00:34:29  tsengel
 * History    : Added category to simplify NSUSerDefaults handling
 * History    :
 * History    : Revision 1.1.1.1  1997/07/09 15:22:51  tsengel
 * History    : New import [GT]
 * History    :
 *************************************************************************/ 

#import <Foundation/Foundation.h>


@interface NSDictionary (MiscDefaultsSupport)

/*" NSUserDefaults-like getters "*/

- (NSString *)stringForKey:(id)aKey;
- (NSArray *)arrayForKey:(id)aKey;
- (NSDictionary *)dictionaryForKey:(id)aKey;
- (NSData *)dataForKey:(id)aKey;
- (NSArray *)stringArrayForKey:(id)aKey;
- (int)integerForKey:(id)aKey;
- (float)floatForKey:(id)aKey;
- (BOOL)boolForKey:(id)aKey;

@end


@interface NSMutableDictionary (MiscDefaultsSupport)

/*" NSUserDefaults-like setters "*/

- (void)setInteger:(int)value forKey:(id)aKey;
- (void)setFloat:(float)value forKey:(id)aKey;
- (void)setBool:(BOOL)value forKey:(id)aKey;

@end


@interface NSString (MiscDefaultsSupport)

/*" Bool value creation. "*/

+ (id)stringWithBool:(BOOL)value;
- (id)initWithBool:(BOOL)value;
- (BOOL)boolValue;

@end


@interface NSMutableString (MiscDefaultsSupport)

/*" Bool value retrival. "*/

- (void)setBoolValue:(BOOL)value;

@end
