/*=========================== MiscWorldCoord.h ==============================*/
/* MiscWorldCoord class contains and supports values representing locations
   in a World coordinate system. Angles are stored internally as radians
   at all times, but may be stored or retrieved as degrees.

   DMA Release 0.8, Copyright @1993 by Genesis Project, Ltd. All Rights
   Reserved. For further information on terms and conditions see
		the MiscKit license.

HISTORY
25-Feb-93  Dale Amon at GPL
	   Created.
*/

#import <Foundation/Foundation.h>
#import <MiscFoundation/MiscCoord.h>

/* ordering of coordinates in storage */
#define MISC_LATITUDE	0
#define MISC_LONGITUDE	1
#define MISC_ALTITUDE	2

@interface MiscWorldCoord:MiscCoord
{

}

- initDescription: (NSString *) txt constants: anObject;

- setCoordLatitudeDegrees: (double) lat
        longitudeDegrees: (double) lon
	        altitude: (double) alt;

- setCoordLatitudeRadians: (double) lat
        longitudeRadians: (double) lon
	        altitude: (double) alt;

- coordLatitudeDegrees: (double *) lat
     longitudeDegrees: (double *) lon
	     altitude: (double *) alt;

- coordLatitudeRadians: (double *) lat
     longitudeRadians: (double *) lon
	     altitude: (double *) alt;

- (double) latitudeRadians;
- (double) latitudeDegrees;
- (double) longitudeRadians;
- (double) longitudeDegrees;
- (double) altitude;

/* blocked methods */
- initDescription: (NSString *) txt
       converter: (id <MiscCoordConverterServer>) aConverter
       constants: anObject;

@end
