/*	MiscSparseArray.h

	Copyright 1995 Christopher J. Kane.

	This notice may not be removed from this source code.
	The use and distribution of this software is governed by the
	terms of the MiscKit license agreement.  Refer to the license
	document included with the MiscKit distribution for the terms.

	Version 1 (1 February 1995)
*/

#import <Foundation/NSObject.h>

@interface MiscSparseArray : NSObject <NSCopying, NSCoding>

- (id)init;					// designated initializer

- (unsigned int)count;
- (id)objectAtIndex:(unsigned int)anIndex;
- (void)putObject:(id)anObject atIndex:(unsigned int)anIndex;

@end

@class NSDictionary;

@interface MiscSparseArray (MiscSparseArrayExtensions)

+ (MiscSparseArray *)sparseArray;

- (BOOL)containsObject:(id)anObject;
- (unsigned int)indexOfObject:(id)anObject;
- (unsigned int)indexOfObjectIdenticalTo:(id)anObject;
- (void)removeObjectAtIndex:(unsigned int)anIndex;
- (void)removeObject:(id)anObject;
- (void)removeObjectIdenticalTo:(id)anObject;
- (void)removeAllObjects;

- (void)makeObjectsPerform:(SEL)aSelector;
- (void)makeObjectsPerform:(SEL)aSelector withObject:(id)anObject;
- (NSEnumerator *)objectEnumerator;
- (NSEnumerator *)reverseObjectEnumerator;

- (BOOL)isEqualToSparseArray:(MiscSparseArray *)otherArray;

- (NSString *)description;
- (NSString *)descriptionWithLocale:(NSDictionary *)aLocale;

@end
