/*	MiscSortedCollection.h

	Copyright 1996 Uwe Hoffmann.

	This notice may not be removed from this source code.
	The use and distribution of this software is governed by the
	terms of the MiscKit license agreement.  Refer to the license
	document included with the MiscKit distribution for the terms.

	Version 2 (August 1996)
*/

#import <Foundation/NSString.h>
#import <Foundation/NSValue.h>
#import <Foundation/NSArray.h>

@interface MiscSortedCollection:NSObject <NSCopying, NSMutableCopying, NSCoding>

- (unsigned)count;
	// Returns number of objects in the collection.
	
- (NSEnumerator *)objectEnumerator;
	// Returns an enumerator object to cycle through the objects.
				
- objectBefore:anObject;
	// Returns the largest object which compares NSOrderedDescending to anObject.
	
- smallest;
	// Returns the smallest object in collection.
		
- (NSArray *)allObjectsOrderedSameAs:anObject;
	// Returns an array containing all the objects which compare NSOrderedSame with anObject.
	// Order is undefined. 
	
@end

@interface MiscSortedCollection (MiscExtendedSortedCollection)

- (BOOL)isEqualToSortedCollection:(MiscSortedCollection *)otherSortedCollection;

- (NSArray *)allObjects;
	// Returns an array containing all the objects.
	// This snapshots the set of objects.
	// Order is smallest to largest
    
@end

@interface MiscMutableSortedCollection: MiscSortedCollection

- (void)removeAllObjectsOrderedSameAs:anObject;
	// Removes objects which compare NSOrderedSame with anObject.
	// Performs -release on each object removed
	
- (void)insertObject:anObject;
	// Inserts anObject in collection. 
	// If object is nil an exception is raised.
	// -retain is applied to the object inserted.

- (void)removeAllObjects;
	// Empties collection
	// Performs -release on each object removed
	
@end

@interface MiscMutableSortedCollection (MiscExtendedMutableSortedCollection)
	
- (void)insertObjectsFromArray:(NSArray *)anArray;
	// Inserts all objects from anArray
	
@end

@interface MiscSortedCollection (MiscSortedCollectionCreation)

+ allocWithZone:(NSZone *)zone;
	// Creates an uninitialized instance of a concrete collection.
	// Substitutes a concrete class if called with MiscSortedCollection.
	// +alloc can also be used to that effect.

+ collection;
	// Creates an autoreleased empty collection.
		
+ collectionWithCompareSelector:(SEL)comparator;
	// Creates an autoreleased empty collection.

+ collectionWithCompareFunction:(int(*)(id, id, void *))comparator context:(void *)context;
	// Creates an autoreleased empty collection.
	
+ stringCollectionOptions:(unsigned)mask range:(NSRange)aRange;
	// Creates an autoreleased empty NSString collection.

+ stringCollectionOptions:(unsigned)mask;
	// Creates an autoreleased empty NSString collection.
	
+ stringCollection;
	// Creates an autoreleased empty NSString collection.
	
+ numberCollection;
	// Creates an autoreleased empty NSNumber collection.
	
+ collectionWithObjects:(id *)objects count:(unsigned)count;
	// Creates an autoreleased collection.

+ collectionWithObjects:(id *)objects count:(unsigned)count compareSelector:(SEL)comparator;
	// Creates an autoreleased collection.

+ collectionWithObjects:(id *)objects count:(unsigned)count compareFunction:(int(*)(id, id, void *))comparator context:(void *)context;
	// Creates an autoreleased collection.
	
+ collectionWithStrings:(NSString **)strings count:(unsigned)count options:(unsigned)mask range:(NSRange)aRange;
	// Creates an autoreleased NSString collection.

+ collectionWithStrings:(NSString **)strings count:(unsigned)count options:(unsigned)mask;
	// Creates an autoreleased NSString collection.

+ collectionWithStrings:(NSString **)strings count:(unsigned)count;
	// Creates an autoreleased NSString collection.
		
+ collectionWithNumbers:(NSNumber **)numbers count:(unsigned)count;
	// Creates an autoreleased NSNumber collection.
	
+ collectionWithObjects:(NSArray *)objects;
	// Creates an autoreleased collection.

+ collectionWithObjects:(NSArray *)objects compareSelector:(SEL)comparator;
	// Creates an autoreleased collection.

+ collectionWithObjects:(NSArray *)objects compareFunction:(int(*)(id, id, void *))comparator context:(void *)context;
	// Creates an autoreleased collection.
	
+ collectionWithStrings:(NSArray *)strings options:(unsigned)mask range:(NSRange)aRange;
	// Creates an autoreleased NSString collection.

+ collectionWithStrings:(NSArray *)strings options:(unsigned)mask;
	// Creates an autoreleased NSString collection.

+ collectionWithStrings:(NSArray *)strings;
	// Creates an autoreleased NSString collection.
	
+ collectionWithNumbers:(NSArray *)numbers;
	// Creates an autoreleased NSNumber collection.
		
@end



