/*======================== MiscCoordConverterClient.h =======================*/
/* The MiscCoordConverterClient protocol is required so that a converter can
   acquire the information it needs to carry out a coordinate system
   conversion.

   The information that can be gotten via this protocol is essentially a
   job description of the work the converter is to do, not a description
   of the MiscCoord object itself.

   DMA Release 0.8, Copyright @1993 by Genesis Project, Ltd. All Rights
   Reserved. For further information on terms and conditions see
		the MiscKit license.

HISTORY
12-Mar-93  Dale Amon at GPL
	   Created.
*/

@protocol MiscCoordConverterClient

+ (double)	radiansToDegrees: (double) angle;
+ (double)	degreesToRadians: (double) angle;
+ (double)	toDegreesOnlyDegrees: (double) deg
			minutes: (double) min
			seconds: (double) sec;

+ (double)	fromDegreesOnly: (double) degrees
			degrees: (double *) deg
			minutes: (double *) min
			seconds: (double *) sec;

+ (unsigned int)	dimensions;
- 					constants;
- (double*)			curPtr;
- (unsigned int)	curBlockSize;

@end

