/*************************************************************************
 * File Name: MiscCommandLineParameterParser.h
 * Version  : 0.6 beta
 * Date     : 08-jul-1995
 *************************************************************************
 *                 COPYRIGHT (C) 1995, 1996 by SciTools Project          *
 *                           and Georg Tuparev                           *
 *                          ALL RIGHTS RESERVED.                         *
 *                                                                       *
 *************************************************************************
 * This software is furnished without a license and may be freely used,  *
 * copied, modified and redistributed, provided that the above copyright *
 * notice is not removed.  This software or any other copies thereof may *
 * be provided or otherwise made available to any other person in any    *
 * form.  No title to and ownership of the software is hereby            *
 * transferred.  It is not permitted to sell this software.  The         *
 * information in this software is subject to change without notice and  *
 * should not be construed as a commitment by the SciTools Project or by *
 * the authors.                                                          *
 * NEITHER THE SCITOOLS PROJECT, NOR THE AUTHORS ASSUME  RESPONSIBILITY  *
 * FOR THE USE OR RELIABILITY OF THIS SOFTWARE PRODUCT. WE DO HOPE,      *
 * HOWEVER, TO GET RESPONSES FROM USERS, ESPECIALLY WHEN IMPROVEMENTS    *
 * HAVE BEEN MADE.                                                       *
 *************************************************************************
 * Description:
 * - Default settings:
 *		unixStyle = YES;
 *		gnuStyle = YES;
 *		multipleCharacterParameters = YES;
 *		multipleParameterString = NO;
 *		parameterChecking = NO;
 *		helpParsing = YES;
 * Notes      : - If parameter checking is enabled, you SHOULD provide a 
 *              list of allowed parameters.
 *              - After archiving/unarchiving or passing the object through
 *              DO the call-bach functions, the delegate and all delegate's
 *              selectors should be reset!
 * To Do      : 
 * Bugs       : 
 * Author(s)  : Georg Tuparev, EMBL & Academia Naturalis, 
 *              Heidelberg, Germany
 * Last update: 08-jul-1995
 * History    : 10-jun-1995    - Birth;
 *              07-jul-1995    - First beta (more or less testet) version;
 *              08-jul-1995    - Full implementation of NSCoding stuff & 
 *                               description method;
 *************************************************************************/

#import <Foundation/NSObject.h>
#import <Foundation/NSString.h>
#import <Foundation/NSArray.h>
#import <Foundation/NSDictionary.h>
#import <Foundation/NSUtilities.h>

#define NO_PARAMETERS -1             // no argv & argc given

typedef void (*Misc_ArgProc)(char **argument);
/* Call-back function used when a command line parameter is found */

@interface MiscCommandLineParameterParser : NSObject <NSCoding>
{
	@private
	unsigned short         argCount;
	char**                 argVector;
	
	NSMutableDictionary*   parameterDictionary;
	
	NSMutableArray*        parameterSeparators;
	
	NSMutableArray*        parseErrors;
	
	NSMutableArray*        parsedParameters;        // Temporary ivar

	BOOL                   unixStyle;
	BOOL                   gnuStyle;
	BOOL                   multipleCharacterParameters;
	BOOL                   multipleParameterString;
	BOOL                   parameterChecking;
	BOOL                   helpParsing;
	BOOL                   parsed;
	
	NSString*              applicationName;

	id                     delegate;
	Misc_ArgProc             helpHandler;
	SEL 	                 helpMethod;
}
+ (void)initialize;

+ (NSString *)className;
+ (NSString *)description;

- (id)init;
- (id)initWithArgumentCount:(const int)argc argumentVector:(const char **)argv;

- (void)dealloc;

- (void)encodeWithCoder:(NSCoder *)aCoder;
- (id)initWithCoder:(NSCoder *)aDecoder;

- (NSString *)description;
- (NSString *)className;

- (id)setArgumentCount:(const int)argc argumentVector:(const char **)argv;
- (int)argumentCount;
- (char **)argumentVector;

- (void)setUnixStyleParametersEnabled:(BOOL)flag;           // -h -f ...
- (BOOL)areUnixStyleParametersEnabled;
- (void)setGNUStyleParametersEnabled:(BOOL)flag;            // --help ...
- (BOOL)areGNUStyleParametersEnabled;
- (void)addMiscParameterSeparator:(char *)separator;
- (void)removeMiscParameterSeparator:(char *)separator;
- (void)removeAllMiscParameterSeparators;
- (void)setMulipleCharacterParametersEnabled:(BOOL)flag;
- (BOOL)areMultipleCharacterParametersEnabled;
- (void)setMultipleParameterStringEnabled:(BOOL)flag;       // tar -xvf
- (BOOL)isMultipleParameterStringEnabled;
- (void)setParameterCheckingEnabled:(BOOL)flag;
- (BOOL)isParameterCheckingEnabled;
- (void)setAutomaticHelpParsingEnabled:(BOOL)flag;
- (BOOL)isAutomaticHelpParsingEnabled;                      // -h --help

- (void)setDelegate:(id)anObject;
- (id)delegate;
- (void)addAllowedParameter:(char *)param hasValue:(BOOL)flag;
- (void)addAllowedParameter:(char *)param hasValue:(BOOL)flag
	handler:(Misc_ArgProc)proc;
- (void)addAllowedParameter:(char *)param hasValue:(BOOL)flag
	selector:(SEL)method;
- (void)setHelpHandler:(Misc_ArgProc)proc;
- (void)setHelpSelector:(SEL)method;
- (NSArray *)allowedParameters;
- (void)removeAllowedParameters;
- (void)parameter:(char *)param conflictsWith:(char *)anotherParam,...;

- (void)parse;
- (NSArray *)parseErrors;

- (NSString *)applicationName;

- (BOOL)isHelpRequired;

- (NSEnumerator *)parameterEnumerator;
- (NSArray *)argumentsForParameter:(NSString *)key;

@end
