/*	MiscTreeStyle.h

	Copyright 1996 Uwe Hoffmann.

	This notice may not be removed from this source code.
	The use and distribution of this software is governed by the
	terms of the MiscKit license agreement.  Refer to the license
	document included with the MiscKit distribution for the terms.

	Version 2 (August 1996)
*/

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>

/*"The MiscLineType defines the line course for lines connecting nodes. 
Lines with MiscStraightLineType connect nodes with a straight line from the middle
of one node to the middle of the other. Lines with MiscBendLineType connect nodes
with lines consisting of three segments, i.e. a line bended with a bending factor."*/
typedef enum {
	MiscStraightLineType,
	MiscBendLineType
} MiscLineType;


@interface MiscTreeStyle:NSObject <NSCopying, NSCoding>
{
@private
	MiscLineType lineType;
	float bendingFactor;
        BOOL shadow;
        NSColor *shadowColor;
}

- (BOOL)isEqual:(id)anObject;

/*"Setting and accessing attributes"*/
+ defaultStyle;
- (MiscLineType)lineType;
- (void)setLineType:(MiscLineType)aLineType;
- (float)bendingFactor;
- (void)setBendingFactor:(float)aBendingFactor;
- (BOOL)shadow;
- (void)setShadow:(BOOL)aBool;
- (NSColor *)shadowColor;
- (void)setShadowColor:(NSColor *)aColor;

@end

