/*****************************************************************************
  CLASS:				MiscGaugeView
  INHERITS FROM:		NSControl
  AUTHOR:				Todd Thomas, Copyright 1995, 1996 Todd Thomas
  DATE BEGAN:			July 11, 1995
  LAST CHANGED:			August 4, 1996
  VERSION:				2.0
  CHANGES:				See the end of the implementation file
  
  This class is basically a view that displays a MiscGaugeCell. Most all the
  methods just pass the message onto the gauge cell. 
  
  As for updating the cell, if just the hand is affected by a method call,
  Control's drawCellInside: method is used for a minimal update. On the 
  other hand, if the method called affects the gauge "face", View's update 
  is called so the cached "face" is redrawn. 
  
  See the MiscGaugeView class for more information, since that is where most
  of the work is done.

  This object is included in the MiscKit by permission from the author
  and its use is governed by the MiscKit license, found in the file
  "LICENSE.rtf" in the MiscKit distribution.  Please refer to that file
  for a list of all applicable permissions and restrictions.  
 *****************************************************************************/

#import <AppKit/NSBox.h>				// For NSTitlePosition
#import <AppKit/NSControl.h>

// Forward class declarations
@class NSColor;
@class NSFont;
@class NSString;


@interface MiscGaugeView : NSControl
{
}

/*" Class initialization "*/
+ (void) initialize;
+ (Class) cellClass;
+ (void) setCellClass:(id)aClass;

/*" Initialization "*/
- (id) initWithFrame:(NSRect)frameRect;

- (id) initWithFrame:(NSRect)frameRect min:(double)min max:(double)max
          startAngle:(float)start range:(float)range 
		  tickInterval:(int)interval;

/*" Our state "*/
- (double) maxValue;
- (void) setMaxValue:(double)max;
- (double) minValue;
- (void) setMinValue:(double)min;
 
- (float) startAngle;
- (void) setStartAngle:(float)newValue;
- (float) angleRange;
- (void) setAngleRange:(float)newValue;
- (int) tickInterval;
- (void) setTickInterval:(int)newValue;
- (float) tickRatio;
- (void) setTickRatio:(float)newRatio;
- (float) handRatio;
- (void) setHandRatio:(float)newRatio;

/*" Our colors "*/
- (NSColor*) gaugeColor;
- (void) setGaugeColor:(NSColor*)color;
- (NSColor*) textColor;
- (void) setTextColor:(NSColor*)color;

/*" Title attributes "*/
- (NSFont*) titleFont;
- (void) setTitleFont:(NSFont*)newFont;
- (NSString*) title;
- (void) setTitle:(NSString*)newTitle;
- (NSTitlePosition) titlePosition;
- (void) setTitlePosition:(NSTitlePosition)newPos;

@end

