
/*
   MiscGaugeCell.h
   INHERITS FROM:	NSCell
   Author:			Todd Thomas, Copyright 1995, 1996 Todd Thomas
   DATE BEGAN:		March 09, 1995
   LAST CHANGED:	August 4, 1996
   VERSION:			1.1
   CHANGES:			See the end of the implementation file.
  
  This class takes care of everything needed to display a gauge. It 
  should also be pretty easy to use your own gauge face and hand in
  a subclass by overriding drawHand:flipped: and drawFace:. See the
  documentation for more details.
  
  We inherit from NSCell (and not from SliderCell or ActionCell)
  because I thought gauges were basically for showing values, not
  altering them. 
  
  The guts of this class originally came from the GaugeView in the 
  BusyBox example located in /NextDeveloper/Examples/Appkit. I
  basically copied the code here, changed the pswraps to allow for
  color, changed the method names, used inherited cell methods,
  and replaced the cache window with an NSImage.
  
  See the implementation file for the original comments that came
  with the GaugeView. (I suppose you could also find it in the 
  /NextDev/Examples directory).

  This object is included in the MiscKit by permission from the author
  and its use is governed by the MiscKit license, found in the file
  "LICENSE.rtf" in the MiscKit distribution.  Please refer to that file
  for a list of all applicable permissions and restrictions.  
 */

#import <AppKit/NSBox.h>	   	// For NSTitlePosition.
#import <AppKit/NSCell.h>


@interface MiscGaugeCell : NSCell
{
	NSImage* cache;				/*" Cached NXImage of the gauge face. "*/
	NSCell* titleCell;			/*" Used to display the title. "*/
	NSTitlePosition titlePosition;	/*" Either NSAtTop or NSAtBottom. "*/
	float radius;				/*" Radius of gauge face. "*/
	NSPoint center;				/*" Center of gauge face. "*/
	float startAngle;			/*" Beginning angle of the gauge numbers "*/
	float angleRange;			/*" Span of the numbers, from startAngle "*/
	float degreesPerUnit;		/*" The number of degrees  per unit mark. "*/ 
	int tickInterval;			/*" The interval of the tick marks. "*/
	float tickRatio;			/*" Tick radius in ratio to the gauge's radius. "*/	
	float handRatio;			/*" Hand length in ratio to the gauge's radius. "*/
	NSColor* gaugeColor;		/*" Color of the gauge face. "*/
	NSColor* textColor;			/*" Color of the text and gauge hand. "*/
	double minValue;			/*" Minimum value of the gauge. "*/
	double maxValue;			/*" Maximum value of the gauge. "*/
}

/*" Initialization/deallocation "*/
+ (void) initialize;
- init;
- (void) dealloc;

/*" Values "*/
- (double) maxValue;
- (void) setMaxValue:(double)max;
- (double) minValue;
- (void) setMinValue:(double)min;

- (void) setFloatValue:(float)val;
- (void) setDoubleValue:(double)val;
- (void) setIntValue:(int)val;
- (void) setStringValue:(NSString*)val;

/*" Angles and ratios "*/
- (float) startAngle;
- (void) setStartAngle:(float)newValue; 
- (float) angleRange;
- (void) setAngleRange:(float)newValue; 
- (int) tickInterval;
- (void) setTickInterval:(int)newValue; 
- (float) tickRatio;
- (void) setTickRatio:(float)newRatio;
- (float) handRatio;
- (void) setHandRatio:(float)newRatio;

/*" Colors "*/
- (NSColor*) gaugeColor;
- (void) setGaugeColor:(NSColor*)color;
- (NSColor*) textColor;
- (void) setTextColor: (NSColor*)color;

/*" Titles "*/
- (NSFont*) titleFont;
- (void) setTitleFont:(NSFont*)newFont;
- (NSString*) title;
- (void) setTitle:(NSString*)newTitle;
- (NSTitlePosition) titlePosition;
- (void)setTitlePosition:(NSTitlePosition)newPos;

/*" Overridden "*/
- (NSSize) cellSizeForBounds:(NSRect)rect;

/*" Drawing "*/
- (void) drawWithFrame:(NSRect)rect inView:(NSView*)controlView;
- (void) drawInteriorWithFrame:(NSRect)cellFrame inView:(NSView*)aView;
- (void) drawHand: (NSRect)rect flipped:(BOOL)viewFlipped;
- (void) drawFace:(NSRect)rect;
- (void) highlight:(BOOL)flag withFrame:(NSRect)cellFrame inView:aView;

/*" Archiving "*/
- (id) initWithCoder:(NSCoder*)aDecoder;
- (void) encodeWithCoder:(NSCoder*)aCoder;

@end

