
/*
   MiscFileDragView.h
   Author:	Todd Thomas <tthomas@thoughtport.com>
   Created:	July 14, 1996

   $Id: MiscFileDragView.h,v 1.2 1996/10/07 02:49:24 todd Exp $

   This object is included in the MiscKit by permission from the author
   and its use is governed by the MiscKit license, found in the file
   "LICENSE.rtf" in the MiscKit distribution.  Please refer to that file
   for a list of all applicable permissions and restrictions.

    Copyright (C) 1996 Todd Thomas
    Use is governed by the MiscKit license
*/

//#import <MiscAppKit/MiscDragView.h>
#import "MiscDragView.h"

@class NSString;
@class NSCoder;
@class NSArray;


@interface MiscFileDragView : MiscDragView
{
}

/*" Class initialization "*/
+ (void) initialize;
+ (Class) cellClass;
+ (void) setCellClass:(Class)newDragCellClass;

/*" Our contents "*/
- (NSString*) filename;
- (void) setFilename:(NSString*)aFilename;
- (NSArray*) filenames;
- (void) setFilenames:(NSArray*)filenames;

/*" Options "*/
- (void) setAllowsDoubleClickLaunch:(BOOL)aBool;
- (BOOL) allowsDoubleClickLaunch;

/*" Workspace help "*/
- (void) launch:(id)sender;

/*" Archiving "*/
- (id) initWithCoder:(NSCoder*)aDecoder;
- (void) encodeWithCoder:(NSCoder*)aCoder;

@end

