
/*
   MiscDragMatrix.h
   Author:	Todd Thomas <tthomas@thoughtport.com>
   Created:	August 31, 1996

   $Id: MiscDragMatrix.h,v 1.3 1996/10/07 02:49:13 todd Exp $

   This object is included in the MiscKit by permission from the author
   and its use is governed by the MiscKit license, found in the file
   "LICENSE.rtf" in the MiscKit distribution.  Please refer to that file
   for a list of all applicable permissions and restrictions.

    Copyright (C) 1995, 1996 Todd Thomas
    Use is governed by the MiscKit license
*/

#import <AppKit/NSMatrix.h>
#import <AppKit/NSDragging.h>

// Forward class declarations
@class NSCoder;
@class NSImage;
@class NSCell;
@class MiscDragCell;


@interface MiscDragMatrix : NSMatrix
{
}

/*" Destination dragging "*/
+ (MiscDragCell*) lastDestinationDragCell;
+ (void) setLastDestinationDragCell:(MiscDragCell*)newDestDragCell;

/*" Initialization/deallocation "*/
- (id) initWithFrame:(NSRect)frame;

/*" Source drag setup "*/
- (void) initializeDragTypes;

/*" Drawing cells "*/
- (void) drawCell:(NSCell*)cell;

/*" Destination dragging "*/
- (MiscDragCell*) _dragCellForDestinationDrag:(id <NSDraggingInfo>)sender;

/*" Archiving "*/
- (id) initWithCoder:(NSCoder *)aDecoder;

@end


@interface MiscDragMatrix (NSDraggingDestination)

- (unsigned int) draggingEntered:(id <NSDraggingInfo>)sender;
- (unsigned int) draggingUpdated:(id <NSDraggingInfo>)sender;
- (void) draggingExited:(id <NSDraggingInfo>)sender;
- (BOOL) prepareForDragOperation:(id <NSDraggingInfo>)sender;
- (BOOL) performDragOperation:(id <NSDraggingInfo>)sender;
- (void) concludeDragOperation:(id <NSDraggingInfo>)sender;

@end
