/*	MiscDiagramTree.h

	Copyright 1996 Uwe Hoffmann.

	This notice may not be removed from this source code.
	The use and distribution of this software is governed by the
	terms of the MiscKit license agreement.  Refer to the license
	document included with the MiscKit distribution for the terms.

	Version 2 (August 1996)
*/

#import <AppKit/NSAttributedString.h>

#import <MiscFoundation/MiscLayoutTree.h>
#import "MiscDiagramShape.h"

typedef struct _MiscDrawState {
        float linewidth;
        NSColor *color;
        NSFont *font;
} MiscDrawState;	

@class MiscUserPath, MiscHitPath, MiscTreeDiagram, MiscNodeStyle;

@interface MiscDiagramTree:MiscLayoutTree
{
@private
	MiscDiagramShape *shape;
    	NSAttributedString *label;
	BOOL selected;
	MiscTreeDiagram *diagram;
	MiscNodeStyle *style;
	int resizeFlag;			
}

/*"Allocating and initializing an MiscDiagramTree instance"*/
+ tree;
+ treeWithLabel:(NSAttributedString *)aLabel shapeType:(MiscShapeType)aShapeType;
+ treeWithSize:(NSSize)aSize shapeType:(MiscShapeType)aShapeType;
- initWithLabel:(NSAttributedString *)aLabel shapeType:(MiscShapeType)aShapeType;
- initWithSize:(NSSize)aSize shapeType:(MiscShapeType)aShapeType;

/*"Drawing"*/
- (void)drawShadow:(MiscDrawState *)aState;
- (void)drawOutline:(MiscDrawState *)aState knobs:(BOOL)knobs viewScale:(float)viewScale;
- (void)drawFill:(MiscDrawState *)aState;
- (void)drawEnding:(MiscDrawState *)aState;
- (void)drawCellsInView:(NSView *)aView attachments:(BOOL)aBool;
- (void)fillLines:(MiscUserPath *)linesPath andAddTo:(NSMutableArray *)nodes;
- (void)fillLines:(MiscUserPath *)linesPath andAddTo:(NSMutableArray *)nodes ifInvolvedInRect:(NSRect)aRect;

/*"Accessing geometric data"*/
- (NSRect)nodeDrawBounds;
- (NSRect)branchDrawBounds;
- (NSRect)textBounds;
- (NSPoint)endPoint;
- (NSPoint)parentEndPoint;
- (NSPoint)childEndPoint;

/*"Accessing and manipulating shape"*/
- (MiscShapeType)shapeType;
- (void)setShapeType:(MiscShapeType)aShapeType;
- (MiscDiagramShape *)shape;

/*"Accessing and manipulating node contents"*/
- (NSAttributedString *)label;
- (void)setLabel:(NSAttributedString *)aLabel;

/*"Managing node selection and hit detection"*/
- (BOOL)isSelected;
- (void)setSelected:(BOOL)aBOOL;
- (BOOL)hit:(MiscHitPath *)hitPath controlPoint:(int *)aInt outline:(BOOL *)aBOOL;
- (NSPoint)controlPoint:(int)aInt;
- (NSRect)controlRect:(int)aInt;

/*"Setting owning diagram"*/
- (void)setDiagram:(MiscTreeDiagram *)aDiagram;
- (MiscTreeDiagram *)diagram;

/*"Accessing and setting node style"*/
- (void)setNodeStyle:(MiscNodeStyle *)aStyle;
- (MiscNodeStyle *)nodeStyle;

/*"Interactive resizing in a view"*/
- (void)setResizingFlag;
- (void)resetResizingFlag;
- (void)drawResizingInView:(NSView *)aView viewScale:(float)aViewScale;
- (void)drawResizing;
- (void)resizeToControlPoint:(NSPoint)aPos :(int *)aInt;

@end
