/*	MiscDiagramShape.h

	Copyright 1996 Uwe Hoffmann.

	This notice may not be removed from this source code.
	The use and distribution of this software is governed by the
	terms of the MiscKit license agreement.  Refer to the license
	document included with the MiscKit distribution for the terms.

	Version 2 (August 1996)
*/

#import <Foundation/NSObject.h>
#import <Foundation/NSGeometry.h>

@class MiscHitPath, MiscUserPath;

typedef enum {
	MiscCircleShapeType,
	MiscCylinderShapeType,
	MiscDiamondShapeType,
	MiscHexagonShapeType,
	MiscHorizontalArrowShapeType,
	MiscHorizontalTriangleShapeType,
	MiscParallelLinesShapeType,
	MiscParallelogramShapeType,
	MiscRectangleShapeType,
	MiscRoundedRectShapeType,
	MiscVerticalArrowShapeType,
	MiscVerticalTriangleShapeType,
} MiscShapeType;

@interface MiscDiagramShape:NSObject <NSCoding, NSCopying>
{

}

/*"Allocating and initializing"*/
- initWithShapeType:(MiscShapeType)aShapeType bounds:(NSRect)aRect;
+ shapeOfType:(MiscShapeType)aShapeType bounds:(NSRect)aRect;

/*"Querying and manipulating shape"*/
- (NSRect)bounds;
- (NSRect)innerBounds;
- (MiscShapeType)shapeType;
- (void)moveTo:(NSPoint)aPos;
- (void)sizeTo:(NSSize)aSize;
- (void)calcIntersection:(NSPoint *)ip angle:(float *)alpha toPoint:(NSPoint)aPoint;
+ (NSSize)calcSizeForInnerSize:(NSSize)aSize shapeType:(MiscShapeType)aShapeType;
- (void)reflectHorizontal;
- (void)reflectVertical;
- (BOOL)reflectedHorizontal;
- (BOOL)reflectedVertical;
- (void)setReflectHorizontal:(BOOL)aBool;
- (void)setReflectVertical:(BOOL)aBool;

/*"Drawing"*/
- (void)drawOutline;
- (void)drawFill;
- (void)drawShadowWithDelta:(NSPoint)aPos;

/*"Hit detection"*/
- (BOOL)hitOutline:(MiscHitPath *)hitPath;
- (BOOL)hitFill:(MiscHitPath *)hitPath;

@end
