/*	MiscUndoManager.h

	Copyright 1996 Uwe Hoffmann.

	This notice may not be removed from this source code.
	The use and distribution of this software is governed by the
	terms of the MiscKit license agreement.  Refer to the license
	document included with the MiscKit distribution for the terms.

	Version 2 (August 1996)
*/


#import <Foundation/Foundation.h>

@class MiscUndoGroup;

@interface MiscUndoManager:NSObject
{
@private
	NSMutableArray *undoArray;	/*"Holds the groups of undo records."*/
	NSMutableArray *redoArray;	/*"Holds the groups of redo records."*/
	int disabled;			/*"Whether MiscUndoManager accepts registrations."*/
	unsigned levelsOfUndo;		/*"Maximum number of undo groups in the undoArray."*/		
	MiscUndoGroup *currentGroup;	/*"The current group which isn't already commited."*/
	BOOL undoing;			/*"The "redo" state, if YES commited groups are added to redoArray."*/
	BOOL redoing;			/*"The "undo" state, if YES commited groups are added to undoArray."*/
        id currentTarget;
}

/*"Starting and commiting record group"*/
- (void)startUndo:(NSString *)undoName :(NSString *)redoName;
- (void)commitUndo;

/*"Registering a undo record"*/ 
- (void)registerRecord:(NSInvocation *)record;
- (void)setCurrentTarget:aTarget;

/*"Methods for menu validation"*/
- (NSString *)undoName;
- (NSString *)redoName;
- (unsigned)numberOfUndos;
- (unsigned)numberOfRedos;

/*"Undo and redo"*/
- (void)undo;
- (void)redo;

/*"Enabling and disabling registration"*/
- (void)disableUndoRegistration;
- (void)reenableUndoRegistration;

/*"Setting and querying the levels of undo"*/
- (unsigned)levelsOfUndo;
- (void)setLevelsOfUndo:(unsigned)value;

/*"Emptying manager"*/ 
- (void)emptyManager;

@end


