/*============================ MiscUTMCoord.h ===============================*/
/* MiscUTMCoord class contains and supports values representing locations
   in a Universal Transverse Mercator coordinate system.

   DMA Release 0.8, Copyright @1993 by Genesis Project, Ltd. All Rights
   Reserved. For further information on terms and conditions see
		the MiscKit license.

HISTORY
25-Feb-93  Dale Amon at GPL
	   Created.
*/

#import <Foundation/Foundation.h>
#import <MiscFoundation/MiscCoord.h>

/* ordering of coordinates in storage */
#define	MISC_EASTINGS	0
#define	MISC_NORTHINGS	1
#define	MISC_ELEVATION	2

@interface MiscUTMCoord:MiscCoord
{

}

- initDescription: (NSString *) txt constants: anObject;

- setCoordEastingMeters: (double) east
        northingMeters: (double) north
       elevationMeters: (double) alt;

- coordEastingMeters: (double *) east
     northingMeters: (double *) north
    elevationMeters: (double*) alt;

- (double) easting;
- (double) northing;
- (double) elevation;

/* blocked methods */
- initDescription: (NSString *) txt
       converter: (id <MiscCoordConverterServer>) aConverter
       constants: anObject;

@end
