/*======================= MiscCylindricalCoord.h ============================*/
/* MiscCylindricalCoord class contains and supports values representing
   locations in a Cylindrical coordinate system.

   DMA Release 0.8, Copyright @1993 by Genesis Project, Ltd. All Rights
   Reserved. For further information on terms and conditions see:
		Documentation/GISKit/Agreements-Legal-README

HISTORY
25-Feb-93  Dale Amon at GPL
	   Created.
*/

#import <Foundation/Foundation.h>
#import <MiscFoundation/MiscMathCoord.h>

/* ordering of coordinates in storage */
#define MISC_RADIUS_CYL	0		/* radius of cylinder */
#define MISC_THETA_CYL	1		/* angle in xy plane */
#define MISC_Z_CYL		2		/* hieght on cylinder access */

@interface MiscCylindricalCoord:MiscMathCoord
{

}

- setCoordRadius: (double) r  thetaDegrees: (double)  theta z: (double)  z;
- setCoordRadius: (double) r  thetaRadians: (double)  theta z: (double)  z;

- coordRadius:    (double*) r thetaDegrees: (double*) theta z: (double*) z;
- coordRadius:    (double*) r thetaRadians: (double*) theta z: (double*) z;

- (double) radius;
- (double) thetaRadians;
- (double) thetaDegrees;
- (double) zCoord;

@end
