/* MiscSwapView.h
 *
 * This subclass of View is able to swap different views into itself. It's
 * used to implement any kind of multipage windows. (Inspectors, Prefs...)
 * This object is a redesign of Greg Bruds swapView.
 *
 * Catergories: - ByObject: Handles automatic swapping. See next headersction.
 *
 * Usage: Just instantiate a view inside IB and tell it what view to show
 *		  next. The MiscSwapView will take care of putting the views back where
 *		  they came from once they will swap out again.
 *		  You can used buffered (faster) or nonButffered (less memory and fast
 *		  enough) swapping. 
 *
 * Notes: This view by default resizes its subview to it current size. But you
 *		  can decide how they are resized by the default NeXTSTEP view resizing
 *		  settings as with every view.
 *		  When using buffered composing resizing is turned OFF because of some
 *		  ugly problems.
 *		  
 * 		  Not using buffered views will save memory and allow resizing 
 *		  over the slightly faster swapping. With fast hardware this might not
 *		  be of any concern at all...so keep the ports rolling:HP, Sun, PPC...?
 *		  To implement buffered views the views windows have to be none 
 *		  deffered and retained. You HAVE to make your window non defered 
 *		  inside IB. (SwapView makes them retained on its own)
 *		  If you know a way to make windows non defered during runtime..please
 *		  let me know.
 *
 *		  Remember to deactivate objects inside a view that has swapped out.
 *		  ColorWell are a good example of such a object!
 *
 * Improved by:		Thomas Engel
 * First changes:   24.01.1994 (Copyright 1994 Thomas Engel)
 * Last modified: 	24.02.1994
 */

//	This object is included in the MiscKit by permission from the author
//	and its use is governed by the MiscKit license, found in the file
//	"LICENSE.rtf" in the MiscKit distribution.  Please refer to that file
//	for a list of all applicable permissions and restrictions.

#import <AppKit/AppKit.h>

@class 	MiscSwapViewItem;


@interface MiscSwapView : NSView
{
    NSView *	contentView;
    NSView *	contentViewsHomeView;
    NSRect		contentViewsHomeRect;
    id			delegate;
    NSColor *	backgroundColor;
    BOOL		backgroundDrawing;
    int			alignment;				// Determins how nonesizeable contentviews will be positioned. NOT implemented.

    // Instances for the ByObject category

    NSMutableArray *	itemArray;
    MiscSwapViewItem *	currentSwapItem;	
    BOOL		tagComparison;

    // Propably not supported in the future...

    BOOL		useBuffering;

    // <<HACK>> This is only present so that we can hook up the initial "trigger" button for the first swap.
    // Its not a clean solution and might be changed in the future...
    
    id			identifier;			
 }

// Basic view init and freeing

+ (void)initialize;
- (id)init;
- (id)initWithFrame:(NSRect)frameRect;
- (void)dealloc;

// Archiving

- (id)initWithCoder:(NSCoder *)aDecoder;
- (void)encodeWithCoder:(NSCoder *)aCoder;

// Awaking

- (void)awake;
- (void)awakeFromNib;
- (id)awakeAfterUsingCoder:(NSCoder *)aCoder;

// Basic instance-control method and delegate setting.
// More details on buffering are at the top of this header file.

- (void)setDelegate:(id)anObject;
- (id)delegate;
- (void)setBackgroundColor:(NSColor *)aColor;
- (NSColor *)backgroundColor;
- (void)setDrawsBackground:(BOOL)flag;
- (BOOL)drawsBackground;
- (BOOL)isOpaque;

// The real work..there's some swapping swapping going on...tadadatadaa..

- (void)setContentView:(NSView *)aView;
- (NSView *)contentView;

// Drawing

- (void)drawRect:(NSRect)rect;

@end


// Get the by Object methods loaded...

#import "MiscSwapView_ByObject.h"

/*
 * History: 24.02.94 Some changes to support buffering.
 *
 *			24.01.94 Took my old swapView and wrote it again...
 *
 *			21.01.94 Did some work to the resizing of swapView.
 *
 *			19.11.93 Started to do some cleanups in this HeaderFile and
 *			 		 resizing got implemented into the object.
 *
 *			17.11.93 Played around with resizing and found it right.
 *
 *
 * Bugs: - There might be problems with swapping out a view with an active
 *		   colorWell. Here some should take care a deactive them.
 *		   You might use the delegate and viewWillSwap.
 *		   Normally you will use subviewitemArray and they will recieve
 *		   swapIn/Out too and can take care of that inside their revert/ok
 *		   methods or what ever.
 *
 *		 - Using buffering doe disable resizing. Maybe there is a solution to
 *		   this porblem. If there is one I might add a setResizing:YES/NO
 *		   method.
 *
 *		 - Read & write do nothing at all. I'm not even sure wether they should
 *		   do something ?
 */

