
/*
   MiscDragCell.h
   Author:		Todd Thomas <tthomas@thoughtport.com>
   Created: 	July 13, 1996
   Changes: 	None yet.

   $Id: MiscDragCell.h,v 1.4 1996/10/07 02:49:10 todd Exp $
   .
  This object is included in the MiscKit by permission from the author
  and its use is governed by the MiscKit license, found in the file
  "LICENSE.rtf" in the MiscKit distribution.  Please refer to that file
  for a list of all applicable permissions and restrictions.

   Copyright (C) 1995, 1996 Todd Thomas
   Use is governed by the MiscKit license
*/

#import <AppKit/NSDragging.h>
#import <AppKit/NSActionCell.h>

// Forward clas declaractions
@class NSImage;
@class NSCell;
@class NSColor;
@class NSString;
@class NSEvent;
@class NSView;
@class NSArray;
@class NSPasteboard;
@class NSCoder;


@interface MiscDragCell : NSActionCell
{
@private
    NSImage* _acceptingImage;			/*" Image to display when accepting a drag. "*/
    NSCell* _imageCell;					/*" Cell that'll draw our image. "*/
    NSImage* _image;					/*" Image we'll display (usually)."*/
    NSCell* _textCell;					/*" Cell that'll draw our title (if enabled) "*/
    NSString* _title;					/*" Title we'll display (if enabled) "*/
    NSBorderType _borderType;			/*" Border (same as NSBox) "*/
    NSColor* _backgroundColor;			/*" Background color (if drawn) "*/
    
    BOOL _allowSourceDragging;			/*" Allow us to start a drag? "*/
    BOOL _allowDestinationDragging;		/*" Allow us to receive a drag? "*/
    BOOL _shadowIncoming;				/*" Dim the incoming source image? "*/

    BOOL _displaysTitle;				/*" Do we display a title? "*/
    BOOL _titleEditable;				/*" Can our title be edited? "*/
    BOOL _titleMultiline;				/*" Can the title span many lines? "*/
}

/*" Class initialization "*/
+ (void) initialize;

/*" Drag support "*/
+ (MiscDragCell*) destinationDragCell;
+ (void) setDestinationDragCell:(MiscDragCell*)currentSource;
+ (MiscDragCell*) sourceDragCell;
+ (void) setSourceDragCell:(MiscDragCell*)currentDest;

+ (NSImage*) dimmedSourceImage;
+ (void) setDimmedSourceImage:(NSImage*)newImage;
+ (NSImage*) dimmedDestinationImage;
+ (void) setDimmedDestinationImage:(NSImage*)newImage;

/*" Initialization/deallocation "*/
- (id) init;
- (void) dealloc;

/*" NSCell overrides "*/
- (BOOL) acceptsFirstResponder;
- (BOOL) isOpaque;

/*" Cell accessors "*/
- (NSCell*) textCell;
- (void) setTextCell:(NSCell*)newTextCell;
- (NSCell*) imageCell;
- (void) setImageCell:(NSCell*)newImageCell;

/*" Our images "*/
- (NSImage*) acceptingImage;
- (void) setAcceptingImage:(NSImage*)anImage;
- (void) setImage:(NSImage*)anImage;

/*" Title manipulation "*/
- (NSString*) title;
- (void) setTitle:(NSString*)newTitle;
- (BOOL) displaysTitle;
- (void) setDisplaysTitle:(BOOL)displays;
- (BOOL) isTitleEditable;
- (void) setTitleEditable:(BOOL)isEditable;
- (BOOL) isTitleMultiline;
- (void) setTitleMultiline:(BOOL)isMultiline;

/*" Dragging options "*/
- (BOOL) allowsSourceDragging;
- (void) setAllowsSourceDragging:(BOOL)aBool;
- (BOOL) allowsDestinationDragging;
- (void) setAllowsDestinationDragging:(BOOL)aBool;

- (BOOL) acceptsForeignDrag;
- (BOOL) acceptsLocalDrag;
- (BOOL) acceptsSelfDrag;
- (BOOL) retainsData;
- (BOOL) shadowsIncoming;
- (void) setShadowsIncoming:(BOOL) aBool;
- (NSColor*) shadowColor;
- (BOOL) dragImageSlidesBack;

/*" Destination dragging "*/
- (NSArray*) acceptingPasteboardTypes;
- (void) cleanupAfterDestinationDrag;

/*" Dragging pasteboard "*/
- (NSPasteboard*) draggingPasteboard;

/*" Source dragging "*/
- (BOOL) prepareForSourceDrag;
- (BOOL) trackMouse:(NSEvent*)theEvent inRect:(NSRect)rect 
	ofView:(NSView*)controlView untilMouseUp:(BOOL)untilMouseUp;
- (void) calculateDragPoint:(NSPoint *)dragPoint andOffset:(NSPoint *)offset;

/*" Drags in progress "*/
- (BOOL) isSourceDragInProgress;
- (BOOL) isDestinationDragInProgress;

/*" Sizing ourselves "*/
- (void) calcDrawInfo:(NSRect)rect;
- (NSSize) cellSize;
- (NSSize) cellSizeForBounds:(NSRect)bounds;
- (NSRect) drawingRectForBounds:(NSRect)bounds;
- (NSRect) imageRectForBounds:(NSRect)bounds;
- (NSRect) titleRectForBounds:(NSRect)bounds;

/*" Display options "*/
- (NSColor*) backgroundColor;
- (void) setBackgroundColor:(NSColor*)newColor;
- (BOOL) isBezeled;
- (void) setBezeled:(BOOL)nowBezeled;
- (BOOL) isBordered;
- (void) setBordered:(BOOL)nowBordered;
- (NSBorderType) borderType;
- (void) setBorderType:(NSBorderType)aType;
- (NSImage*) imageToDisplay;
- (NSString*) titleToDisplay;
- (NSImage*) imageToDrag;

/*" Dimmed image creation "*/
- (void) createDimmedSourceImage;
- (void) createDimmedDestinationImageUsingImage:(NSImage*)origImage;

/*" Display hooks "*/
- (void) prepareTextCellForDisplay;

/*" Drawing "*/
- (void) drawWithFrame:(NSRect)frame inView:(NSView*)controlView;
- (void) drawInteriorWithFrame:(NSRect)frame inView:(NSView*)controlView;

/*" Copying "*/
- (id) copyWithZone:(NSZone*)zone;

/*" Archiving "*/
- (id) initWithCoder:(NSCoder*)aDecoder;
- (void) encodeWithCoder:(NSCoder*)aCoder;

@end


@interface MiscDragCell (NSDraggingSource)

- (unsigned int) draggingSourceOperationMaskForLocal:(BOOL)flag;
- (void) draggedImage:(NSImage*)image endedAt:(NSPoint)screenPoint deposited:(BOOL)flag;

@end


@interface MiscDragCell (NSDraggingDestination)

- (unsigned int) draggingEntered:(id <NSDraggingInfo>)sender;
- (unsigned int) draggingUpdated:(id <NSDraggingInfo>)sender;
- (void) draggingExited:(id <NSDraggingInfo>)sender;
- (BOOL) prepareForDragOperation:(id <NSDraggingInfo>)sender;
- (BOOL) performDragOperation:(id <NSDraggingInfo>)sender;
- (void) concludeDragOperation:(id <NSDraggingInfo>)sender;

@end

