
/*
  MiscArrowButton.h
  INHERITS FROM: 	NSButton
  AUTHOR:			Todd Thomas, Copyright 1994, 1995, 1996 by Todd Thomas 
  START DATE:		Jan 16, 1993
  LAST CHANGED:		August 4, 1996 
  VERSION:			2.0
 
  A recreation of that button from Websters.app (in Preferences).
  This class is just a control to display the ArrowButtonCell. It
  has the same relationship with ArrowButtonCell, as NSButton and 
  NSButtonCell.
   
  This object is included in the MiscKit by permission from the author
  and its use is governed by the MiscKit license, found in the file
  "LICENSE.rtf" in the MiscKit distribution.  Please refer to that file
  for a list of all applicable permissions and restrictions.
*/
 
#import <AppKit/NSButton.h>
#import <Foundation/NSGeometry.h>		// For NSRect

#import "MiscArrowButtonCell.h"


@interface MiscArrowButton : NSButton
{
}

/*" Class initialization "*/
+ (void) initialize;
+ (Class) cellClass;
+ (void) setCellClass:(Class)classId;

/*" Initialization/deallocation "*/
- (id) initWithFrame:(NSRect)frameRect;

/*" Our alignment "*/
- (MiscArrowAlignment) arrowAlignment;	
- (void) setArrowAlignment:(MiscArrowAlignment)alignment;

@end

