#import "OhmsLawObject.h"

@implementation OhmsLawObject

// Global Variables
float VoltsValue;
float AmperesValue;
float OhmsValue;
float WattsValue;



- (void)Calculate:(id)sender
{

	// Local Variables
    	int WhichOne;

	// Assigns the value of the currently selected button
	WhichOne = [FindButton selectedTag]; // Using tag as a reference


	switch (WhichOne)  { // start switch

// Find the Resistance "Ohms"   R=V/I
case 0:
        // Gets the value from the Ampere field
        AmperesValue = [Amperes floatValue];

       // Gets the value from the Volts field 
       VoltsValue = [Volts floatValue];

       OhmsValue = (VoltsValue/AmperesValue);

       [Ohms setFloatValue:OhmsValue];

  break;

// Find the Current "Ampere"   I= V/R  
case 1:
       // Gets the value from the Ohms field
        OhmsValue = [Ohms floatValue];

       // Gets the value from the Volts field
       VoltsValue = [Volts floatValue];

       AmperesValue= (VoltsValue/OhmsValue);

       [Amperes setFloatValue:AmperesValue];

  break;

// Find the Voltage "Volt"  V=I*R   
case 2:
      // Gets the value from the Ohms field 
        OhmsValue = [Ohms floatValue];

       // Gets the value from the Ampere field 
       AmperesValue = [Amperes floatValue];

       VoltsValue= (AmperesValue*OhmsValue);

       [Volts setFloatValue:VoltsValue];

    break;

// Find the Power "Watts" 
case 3:

       // Gets the value from the Ohms field
       OhmsValue = [Ohms floatValue];

       // Gets the value from the Ampere  field
        AmperesValue = [Amperes floatValue];

       // Gets the value from the Volts field
       VoltsValue = [Volts floatValue];


// Make sure all the values are found then find the Watts

//  Find the value for Ohms    
if (OhmsValue == 0)
{
        OhmsValue= (VoltsValue/AmperesValue);
	      	[Ohms setFloatValue:OhmsValue];
}

// Find the value for Amperes    
if (AmperesValue == 0)
{
        AmperesValue= (VoltsValue/OhmsValue);
        [Amperes setFloatValue:AmperesValue];
}

//    Find the value for Volts  
if (VoltsValue == 0)
{
        VoltsValue= (AmperesValue*OhmsValue);
        [Volts setFloatValue:VoltsValue];
}

// Find the Watts     P=I*V    

       WattsValue= (AmperesValue*VoltsValue);
       [Watts setFloatValue:WattsValue];

        break;

                        } // end switch    

    
}

- (void)FindAmpere:(id)sender
{

    [self SetToZero:sender];

    [[CalcTextFields cellAtIndex:0] setTitle:@"Ohms :"];
    [[CalcTextFields cellAtIndex:1] setTitle:@"Amperes :"];
    [[CalcTextFields cellAtIndex:2] setTitle:@"Volts :"];
    [[CalcTextFields cellAtIndex:3] setTitle:@""];

    [Ohms setEnabled:YES];
    [Amperes setEnabled:NO];
    [Volts setEnabled:YES];
    [Watts setEnabled:NO];
    
}

- (void)FindOhms:(id)sender
{

    [self SetToZero:sender]; // Set the form value to ZERO 

    [[CalcTextFields cellAtIndex:0] setTitle:@"Ohms :"];
    [[CalcTextFields cellAtIndex:1] setTitle:@"Amperes :"];
    [[CalcTextFields cellAtIndex:2] setTitle:@"Volts :"];
    [[CalcTextFields cellAtIndex:3] setTitle:@""];

    [Ohms setEnabled:NO]; // Disable the form (noneditable)

    [Amperes setEnabled:YES]; // Enables the form
    [Volts setEnabled:YES]; // Enables the form

    [Watts setEnabled:NO]; // Disable the form (noneditable) 
    
}

- (void)FindVolts:(id)sender
{
    [self SetToZero:sender];

    [[CalcTextFields cellAtIndex:0] setTitle:@"Ohms :"];
    [[CalcTextFields cellAtIndex:1] setTitle:@"Amperes :"];
    [[CalcTextFields cellAtIndex:2] setTitle:@"Volts :"];
    [[CalcTextFields cellAtIndex:3] setTitle:@""];

    [Ohms setEnabled:YES];
    [Amperes setEnabled:YES];
    [Volts setEnabled:NO];
    [Watts setEnabled:NO];
    
}

- (void)FindWatts:(id)sender
{

    [self SetToZero:sender];

    [[CalcTextFields cellAtIndex:0] setTitle:@"Ohms :"];
    [[CalcTextFields cellAtIndex:1] setTitle:@"Amperes :"];
    [[CalcTextFields cellAtIndex:2] setTitle:@"Volts :"];
    [[CalcTextFields cellAtIndex:3] setTitle:@"Watts :"];

    [Ohms setEnabled:YES];
    [Amperes setEnabled:YES];
    [Volts setEnabled:YES];
    [Watts setEnabled:NO];
    
}

- (void)PrintOhmsTable:(id)sender
// This method will print the Ohms Law Table
{

         [OhmsTable print:self];
}

- (void)SetToZero:(id)sender
// This sets the values of the forms to ZERO
{
            [Ohms setFloatValue:0];
            [Amperes setFloatValue:0];
            [Volts setFloatValue:0];
            [Watts setFloatValue:0];
}

@end
