/* Reminder.m created by wjabi on Sat 17-Jan-1998 */

#import "Reminder.h"

@implementation Reminder

- (void) cancelReminder
{
    if(timer)
      {
        [timer invalidate];
      }
}

- (void) convertSecondsToTime:(long)totalSeconds :(int *)hrs :(int *)mins :(int *)secs
{
    *hrs = totalSeconds/3600;
    *mins = ((totalSeconds%3600)/60);
    *secs = ((totalSeconds%60));
}

- (long) convertTimeToSeconds:(int)hr :(int)min :(int)sec
{
    return (long) ((hr *3600) + (min * 60) + sec);
}

- (BOOL) getRepeats
{
    return repeats;
}

- (BOOL) getRelative
{
    return relative;
}

- (BOOL) getValid
{
    if(timer)
      {
        return [timer isValid];
      }
    else
      {
        return NO;
      }
}

-(id) init
{
    [super init];
    reminderString = @"";
    repeats = NO;
    relative = NO;
    return self;
}

- (void) remainingTime:(int *)hr minutes:(int *)min seconds:(int *)sec
{
    NSDate *fireDate;
    NSTimeInterval timeInterval = 0;
    if(timer)
      {
        if([timer isValid])
          {
            fireDate = [timer fireDate];
            timeInterval = [fireDate timeIntervalSinceNow];
          }
      }
    if(relative == 0)
      {
        *hr = hours;
        *min = minutes;
        *sec = seconds;
        return;
      }
    else
      {
        if(timeInterval > 0)
          {
            [self convertSecondsToTime:timeInterval :hr :min :sec];
            return;
          }
        else
          {
            *hr  = 0;
            *min = 0;
            *sec = 0;
            return;
          }

      }
}

- (void) setRelative:(BOOL)relativeValue
{
    relative = relativeValue;
}

- (id) setReminder:(int)hr :(int)min :(int)sec :aTarget :(SEL)aSelector :(BOOL)repeatsValue :(BOOL)relativeValue :(BOOL)soundValue :(BOOL)alertPanelValue :(NSString *)aString
{
    long timeInterval, todayTimeInterval, newTimeInterval;
    NSDate *newDate, *today;
    repeats = repeatsValue;
    relative = relativeValue;
    shouldEmitSound = soundValue;
    shouldShowAlertPanel = alertPanelValue;
    [self setStringValue:aString];
    if(timer)
      {
        [timer invalidate];
        [timer autorelease];
      }
    if (relative == NO)
      {
        hours = hr;
        minutes = min;
        seconds = sec;
        newDate = [NSDate dateWithNaturalLanguageString:[NSString stringWithFormat:@"today %02d:%02d:%02d",hr, min, sec] locale:nil];
        newTimeInterval = [newDate timeIntervalSince1970];
        today = [NSDate date];
        todayTimeInterval = [today timeIntervalSince1970];
        if (newTimeInterval < todayTimeInterval)
          {
            newTimeInterval += 12*60*60;
          }
        if (newTimeInterval < todayTimeInterval)
          {
            newTimeInterval += 12*60*60;
          }
        timeInterval = newTimeInterval - todayTimeInterval;
      }
    else
      {
        timeInterval = [self convertTimeToSeconds:hr :min :sec];
      }
    timer = [NSTimer scheduledTimerWithTimeInterval:(NSTimeInterval)timeInterval target:aTarget selector:aSelector userInfo:self repeats:(BOOL)repeats];
    [timer retain];
    return self;
}

- (void) setRepeats:(BOOL)repeatsValue
{
    repeats = repeatsValue;
}

- (void) setStringValue:(NSString *)aString
{
    if(reminderString)
      {
        [reminderString autorelease];
      }
    reminderString = [aString copy];
}

- (BOOL) shouldEmitSound
{
    return shouldEmitSound;
}

- (BOOL) shouldShowAlertPanel
{
    return shouldShowAlertPanel;
}

- (NSString *) stringValue
{
    return reminderString;
}

@end
