#import <AppKit/AppKit.h>

@interface TWCell : NSActionCell
{
	int	_displayMode;	// DISPLAY_MODE_LINEAR or DISPLAY_MODE_RADIAL
	int	_direction;	// DIRECTION_HORIZONTAL or DIRECTION_VERTICAL

	float	_floatValue;	// Float value of TW
	float	_lastFloatValue;// Used to calculate relative change in value

	float	_visMax;     	// Value at top or right point
	float	_visMin;     	// Value at bottom or left point

	int	_absMode;	// ABSOLUTE_UNBOUNDED, _BOUNDED and _WRAPPED
	float	_absMax;     	// Max value (meaningless if unbounded)
	float	_absMin;     	// Min value (meaningless if unbounded)
	
	BOOL	_snapsBack;	// Whether TW snaps back to a value when done
	float	_snapBackValue;	// Value to snap back to (typically 0)

	int	_dashInterval;	// How often to draw a dash (in points or degs)	
	BOOL	_showMainDash;	// Set this to NO if you want relative vals

	NSColor *_color;       	// Color of the Thumbwheel
	NSImage	*_image; 	// Background of Thumbwheel in radial mode
	NSRect	_cellFrame;	// Frame of the cell at track mouse time.
}

- init;

// Overridden Cell Methods
- (BOOL)continueTracking:(NSPoint)lastPoint at:(NSPoint)currPoint inView:(NSView *)view;
- (void)stopTracking:(NSPoint)lastPoint at:(NSPoint)stopPoint inView:(NSView *)view mouseIsUp:(BOOL)flag;

// The value that corresponds to a point relative to visible range and frame
- (float)floatValueAtPoint:(NSPoint)point forFrame:(NSRect)frame;

// Direction: vertical or horizontal
- (int)direction;
- (void)setDirection:(int)dir;
- (BOOL)isVertical;
- (void)setVertical;
- (BOOL)isHorizontal;
- (void)setHorizontal;

// DisplayMode: radial or linear
- (int)displayMode;
- (void)setDisplayMode:(int)mode;
- (BOOL)isRadial;
- (void)setRadial;
- (BOOL)isLinear;
- (void)setLinear;

// Overridden to set the last float value and apply wrap or bound.
- (void)setIntValue:(int)val;
- (void)setFloatValue:(float)val;

// Visible min and max
- (float)visibleMax;
- (void)setVisibleMax:(float)max;
- (float)visibleMin;
- (void)setVisibleMin:(float)min;
- (float)visibleRange;
- (float)middleValue;

// Absolute mode: unbounded, bounded or wrapped
- (int)absoluteMode;
- (void)setAbsoluteMode:(int)mode;
- (BOOL)isUnbounded;
- (void)setUnbounded;
- (BOOL)isBounded;
- (void)setBounded;
- (BOOL)isWrapped;
- (void)setWrapped;
- (float)absoluteMax;
- (void)setAbsoluteMax:(float)value;
- (float)absoluteMin;
- (void)setAbsoluteMin:(float)value;
- (float)absoluteRange;

// Relative Values
- (int)relativeIntValue;
- (float)relativeFloatValue;
- (void)resetRelativeValue;

// Query and set the last float value. Used internally
- (float)lastFloatValue;
- (void)setLastFloatValue:(float)value;

// Snap back characteristic
- (BOOL)snapsBack;
- (void)setSnapsBack:(BOOL)flag;
- (float)snapBackValue;
- (void)setSnapBackValue:(float)val;

// Dash interval (set in degrees or points depending on displayMode)
- (float)dashInterval;
- (void)setDashInterval:(float)val;

// Showing the main dash
- (BOOL)showMainDash;
- (void)setShowMainDash:(BOOL)flag;

// Color of the ThumbWheel
- (NSColor *)color;
- (void)setColor:(NSColor *)color;

// Shift calcs the shift of the dashes from the floatValue, visRange & frame
- (int)shift:(NSRect)frame;

// Override highlight:inView:lit: so that it does nothing
- (void)highlight:(BOOL)flag withFrame:(NSRect)frame inView:(NSView *)view;

// Override this so that we track mouse whether or not it is on top of us.
+ (BOOL)prefersTrackingUntilMouseUp;

@end

#define DISPLAY_MODE_LINEAR		0
#define DISPLAY_MODE_RADIAL		1

#define DIRECTION_HORIZONTAL		0
#define DIRECTION_VERTICAL		1

#define ABSOLUTE_UNBOUNDED		0
#define ABSOLUTE_BOUNDED		1
#define ABSOLUTE_WRAPPED		2
