// TETextUtils.h
// TextExtras - Yellow Box
//
// Copyright 1996-1999, Mike Ferris.
// All rights reserved.

#import <AppKit/AppKit.h>

// Identifying paragraph boundaries
extern BOOL TE_IsParagraphSeparator(unichar uchar, NSString *str, unsigned index);
extern BOOL TE_IsHardLineBreakUnichar(unichar uchar, NSString *str, unsigned index);

// Space/Tab utilities
extern unsigned TE_numberOfLeadingSpacesFromRangeInString(NSString *string, NSRange *range, unsigned tabWidth);
extern NSString *TE_tabbifiedStringWithNumberOfSpaces(unsigned origNumSpaces, unsigned tabWidth);
extern NSArray *TE_tabStopArrayForFontAndTabWidth(NSFont *font, unsigned tabWidth);

// Nest/Unnest utilities
extern NSAttributedString *TE_attributedStringByIndentingParagraphs(NSAttributedString *origString, int levels,  NSRange *selRange, NSDictionary *defaultAttrs, unsigned tabWidth, unsigned indentWidth);

// Brace matching utilities
extern unichar TE_matchingDelimiter(unichar delimiter);
extern BOOL TE_isOpeningBrace(unichar delimiter);
extern BOOL TE_isClosingBrace(unichar delimiter);
extern NSRange TE_findMatchingBraceForRangeInString(NSRange origRange, NSString *string);

