// TEPreferencesController.h
// TextExtras - Yellow Box
//
// Copyright 1996-1999, Mike Ferris.
// All rights reserved.

#import <AppKit/AppKit.h>

@interface TEPreferencesController : NSWindowController {
    IBOutlet NSTabView *tabView;
    
    IBOutlet NSBox *generalBox;
    IBOutlet NSForm *widthForm;
    IBOutlet NSMatrix *checkBoxMatrix;
    IBOutlet NSButton *makeGlobalButton;

    IBOutlet NSBox *completionBox;
    IBOutlet NSTableView *completionTableView;
    IBOutlet NSTextView *completionTextView;
    IBOutlet NSButton *addCompletionButton;
    IBOutlet NSButton *removeCompletionButton;

    IBOutlet NSBox *openQuicklyBox;
    IBOutlet NSTextView *openQuicklyTextView;
    IBOutlet NSButton *addOpenQuicklyButton;
    IBOutlet NSButton *openQuicklyGlobalButton;

    IBOutlet NSBox *menuSettingsBox;
    IBOutlet NSMatrix *globalMenuRadioButtons;
    IBOutlet NSButton *globalDebugMenuCheckbox;
    IBOutlet NSMatrix *localMenuRadioButtons;

    IBOutlet NSBox *modifierFlagsBox;
    IBOutlet NSPopUpButton *leftControlPopUp;
    IBOutlet NSPopUpButton *rightControlPopUp;
    IBOutlet NSPopUpButton *leftAlternatePopUp;
    IBOutlet NSPopUpButton *rightAlternatePopUp;
    IBOutlet NSButton *mnemonicsWorkInTextCheckbox;

    NSTabViewItem *generalTab;
    NSTabViewItem *completionTab;
    NSTabViewItem *openQuicklyTab;
    NSTabViewItem *menuSettingsTab;
#ifdef WIN32
    NSTabViewItem *modifierFlagsTab;
#endif

    unsigned tabWidth;
    unsigned indentWidth;
    unsigned wrappedLineIndentWidth;
    BOOL indentWrappedLines;
    BOOL selectToMatchingBrace;
    BOOL showMatchingBrace;
    BOOL fancyEscapeCompletion;
    BOOL enforceTabStops;
    NSMutableArray *openQuicklyPaths;
    BOOL savesOpenQuicklyPathsGlobally;
    NSMutableDictionary *completionDict;
    NSArray *sortedCompletionKeys;
    NSDate *lastReadCompletionDictDate;
    BOOL globalTryMenu;
    BOOL globalTryMenuHard;
    BOOL globalDebugMenu;
    BOOL localStoresMenuSettings;
    BOOL localTryMenu;
    BOOL localTryMenuHard;

    BOOL completionTextViewChanged;
    BOOL openQuicklyTextViewChanged;

#ifdef WIN32
    int leftControlModifier;
    int rightControlModifier;
    int leftAlternateModifier;
    int rightAlternateModifier;
    BOOL mnemonicsWorkInText;
#endif
}

+ (BOOL)tryToInstallExtrasMenu;
+ (BOOL)tryHardToInstallExtrasMenu;
+ (BOOL)tryToInstallDebugMenu;

+ (id)sharedPreferencesController;

- (void)readDefaults;

- (unsigned)tabWidth;
- (unsigned)indentWidth;
- (unsigned)wrappedLineIndentWidth;
- (BOOL)indentWrappedLines;
- (BOOL)selectToMatchingBrace;
- (BOOL)showMatchingBrace;
- (BOOL)fancyEscapeCompletion;
- (BOOL)enforceTabStops;
- (NSArray *)openQuicklyPaths;
- (BOOL)savesOpenQuicklyPathsGlobally;
- (NSDictionary *)completionDictionary;

- (IBAction)checkBoxMatrixAction:(id)sender;
- (IBAction)makeGlobalAction:(id)sender;
- (IBAction)menuSettingsAction:(id)sender;
- (IBAction)addCompletionAction:(id)sender;
- (IBAction)removeCompletionAction:(id)sender;
- (IBAction)addOpenQuicklyAction:(id)sender;
- (IBAction)openQuicklyGlobalAction:(id)sender;
- (IBAction)modifierFlagPopUpAction:(id)sender;
- (IBAction)mnemonicsWorkInTextCheckboxAction:(id)sender;

- (void)updateCompletionTextView;
- (void)saveSelectedCompletionText;
- (void)writeCompletionDict;
- (void)updateOpenQuicklyTextView;
- (void)saveOpenQuicklyPaths;
- (void)readCompletionDictIfNeeded;

@end

extern NSString *TEPreferencesDidChangeNotification;
