// TEOpenQuicklyController.m
// TextExtras - Yellow Box
//
// Copyright 1996-1999, Mike Ferris.
// All rights reserved.

#import "TEOpenQuicklyController.h"
#import "TEDirectoryListController.h"
#import "TEPreferencesController.h"
#import <MOKit/MOKit.h>

#import <AppKit/NSInterfaceStyle.h>

@implementation TEOpenQuicklyController

+ (id)sharedOpenQuicklyController {
    static TEOpenQuicklyController *sharedInstance = nil;
    if (!sharedInstance) {
        sharedInstance = [[TEOpenQuicklyController alloc] init];
    }
    return sharedInstance;
}

- (id)init {
    self = [super initWithWindowNibName:@"TEOpenQuickly" owner:self];
    if (self) {
        MOCompletionStrategy *strat;

#ifdef WIN32
        basePath = @"C:\\";
#else
        basePath = @"/";
#endif
        completionManager = [[MOCompletionManager allocWithZone:[self zone]] init];
        strat = [[MOFileCompletionStrategy allocWithZone:[self zone]] init];
        [completionManager setCompletionStrategies:[NSArray arrayWithObject:strat]];
        [strat release];
    }
    return self;
}

- (void)dealloc {
    [basePath release];
    [completionManager release];
    [super dealloc];
}

- (void)windowDidLoad {
    BOOL win95Style = ((NSInterfaceStyleForKey(nil, [self window]) == NSWindows95InterfaceStyle) ? YES : NO);
    NSButtonCell *okButtonCell, *cancelButtonCell;
    
    [super windowDidLoad];
    
    // Buttons are "backwards" on windows.
    if (win95Style) {
        okButtonCell = [buttonMatrix cellAtRow:0 column:0];
        cancelButtonCell = [buttonMatrix cellAtRow:0 column:1];
    } else {
        okButtonCell = [buttonMatrix cellAtRow:0 column:1];
        cancelButtonCell = [buttonMatrix cellAtRow:0 column:0];
    }
    [okButtonCell setTitle:NSLocalizedStringFromTableInBundle(@"OK", @"TextExtras", [NSBundle bundleForClass:[self class]], @"OK button title.")];
    [okButtonCell setTag:NSOKButton];
    [okButtonCell setKeyEquivalent:@"\r"];
    [pathForm setTarget:okButtonCell];
    [pathForm setAction:@selector(performClick:)];
    [[pathForm cellAtIndex:0] setStringValue:@""];
    [cancelButtonCell setTitle:NSLocalizedStringFromTableInBundle(@"Cancel", @"TextExtras", [NSBundle bundleForClass:[self class]], @"Cancel button title.")];
    [cancelButtonCell setTag:NSCancelButton];
}

- (BOOL)tryToOpenFile:(NSString *)path {
    id appDelegate = [NSApp delegate];
    BOOL isDirectory = NO;
    
    if ([[NSFileManager defaultManager] fileExistsAtPath:path isDirectory:&isDirectory]) {
        // Let the app try to open it
        if (appDelegate && [appDelegate respondsToSelector:@selector(application:openFile:)]) {
            if ([appDelegate application:NSApp openFile:path]) {
                // It opened the file.  We're done.
                return YES;
            }
        } else {
            if ([[NSDocumentController sharedDocumentController] openDocumentWithContentsOfFile:path display:YES] != nil) {
                // It opened the file.  We're done.
                return YES;
            }
        }

        if (isDirectory) {
            // Give up... for now.  Later we may want to open directories that the app can't by using our own windows which can display their contents kind of like Edit Classic did.
            TEDirectoryListController *dirController = [[TEDirectoryListController allocWithZone:[self zone]] initWithDirectory:path];
            [dirController showWindow:self];
            return YES;
        }
    }
    return NO;
}

- (void)buttonMatrixAction:(id)sender {
    [NSApp stopModalWithCode:[[sender selectedCell] tag]];
}

- (void)runOpenQuicklyPanel:(id)sender {
    NSWindow *w = [self window];  // Force nib loading.
    NSString *mainWindowFile;
    int result;
#if 0
    id mainWindowFR;
#endif
    
    // We need to find an appropriate basePath to use.  We will use the mainWindow's filename's directory if we can, otherwise we will use the same thing we did last time.  Initial value is root for Mach, "C:\" for Windows.
    mainWindowFile = [[NSApp mainWindow] representedFilename];
    if (mainWindowFile && ![mainWindowFile isEqualToString:@""]) {
        [basePath release];
        if ([[[NSApp mainWindow] delegate] isKindOfClass:[TEDirectoryListController class]]) {
            basePath = [mainWindowFile copyWithZone:[self zone]];
        } else {
            basePath = [[mainWindowFile stringByDeletingLastPathComponent] copyWithZone:[self zone]];
        }
    }
#if 0
    // If the first responder is a text object we'll take the selected text for the field
    mainWindowFR = [[NSApp mainWindow] firstResponder];
    if ([mainWindowFR isKindOfClass:[NSText class]]) {
        NSRange selRange = [mainWindowFR selectedRange];
        if (selRange.length > 0) {
            [[pathForm cellAtIndex:0] setStringValue:[[mainWindowFR string] substringWithRange:selRange]];
        } else {
            [[pathForm cellAtIndex:0] setStringValue:@""];
        }
    } else {
        [[pathForm cellAtIndex:0] setStringValue:@""];
    }
#endif

    [w makeFirstResponder:w];
    result = [NSApp runModalForWindow:w];
    [w orderOut:self];

    if (result == NSOKButton) {
        NSString *path, *tempPath;
        BOOL exists, isDirectory;
        
        if (![w makeFirstResponder:w]) {
            [w endEditingFor:nil];
        }

        path = [[[pathForm cellAtIndex:0] stringValue] stringByStandardizingPath];
        tempPath = path;
        
        if (![path isAbsolutePath]) {
#ifdef WIN32
            if ([path hasPrefix:@"/"] || [path hasPrefix:@"\\"]) {
                // Just take the drive letter from the basePath
                tempPath = [[[[basePath pathComponents] objectAtIndex:0] stringByAppendingPathComponent:path] stringByStandardizingPath];
            } else {
#endif
                tempPath = [[basePath stringByAppendingPathComponent:path] stringByStandardizingPath];
#ifdef WIN32
            }
#endif
        }
        exists = [[NSFileManager defaultManager] fileExistsAtPath:tempPath isDirectory:&isDirectory];
        if (!exists && ![path isAbsolutePath]) {
#ifdef WIN32
            // Make sure it wasn't semi-absolute...
            if ([path hasPrefix:@"/"] || [path hasPrefix:@"\\"]) {
#endif
                NSArray *paths = [[TEPreferencesController sharedPreferencesController] openQuicklyPaths];
                unsigned i, c = [paths count];
                for (i=0; (!exists && i<c); i++) {
                    tempPath = [[[paths objectAtIndex:i] stringByAppendingPathComponent:path] stringByStandardizingPath];
                    exists = [[NSFileManager defaultManager] fileExistsAtPath:tempPath isDirectory:&isDirectory];
                }

#ifdef WIN32
            }
#endif
        }

        if (exists) {
            // The file exists.
            // Remember the directory of the file we opened in case there's no filename for the main window next time.
            [basePath release];
            basePath = [[tempPath stringByDeletingLastPathComponent] copyWithZone:[self zone]];

            if (![self tryToOpenFile:tempPath]) {
                NSBeep();
            }
        } else {
            NSBeep();
        }
    }
}

- (BOOL)control:(NSControl *)control textView:(NSTextView *)textView doCommandBySelector:(SEL)commandSelector {
    if (commandSelector == @selector(complete:)) {
        [completionManager doCompletionInTextView:textView startLimit:0 basePath:basePath];
        return YES;
    }
    return NO;
}

- (void)controlTextDidChange:(NSNotification *)notification {
    [completionManager dumpCompletionState];
}

- (void)controlTextDidEndEditing:(NSNotification *)notification {
    [completionManager dumpCompletionState];
}

- (void)windowWillClose:(NSNotification *)notification {
    [NSApp stopModalWithCode:NSCancelButton];
}

- (BOOL)windowShouldClose:(NSWindow *)window {
    // MF: To prevent AppKit from doing a misguided stopModalWithCode: when the window is closed.  Actually, on Windows we could leave out this method and remove the windowWillClose: handler above, but on Mach, the windowWillClose: is necessary.  Therefore, to avoid stopModalWithCode: from being invoked twice (which actually would be harmless...), we implement this method.  It is super-nasty that on Windows closing a modal window behaves differently than on Mach, but it does.
    return YES;
}

@end
