// TEInfoPanelController.m
// TextExtras - Yellow Box
//
// Copyright 1996-1999, Mike Ferris.
// All rights reserved.

#import "TEInfoPanelController.h"
#import <MOKit/MOKit.h>

#define README_FILE @"README"
#define README_EXTENSION @"rtf"


@implementation TEInfoPanelController

+ (id)sharedInfoPanelController {
    static TEInfoPanelController *sharedInstance = nil;
    if (!sharedInstance) {
        sharedInstance = [[TEInfoPanelController alloc] init];
    }
    return sharedInstance;
}

- (id)init {
    return [super initWithWindowNibName:@"TEInfo" owner:self];
}

- (void)windowDidLoad {
    extern const double TETextExtrasVersionNumber;
    NSString *readMePath;

    [super windowDidLoad];

    // It is assumed that versionField comes out of the nib with a format string with one %f which is to be replaced by the version number.
    [versionField setStringValue:[NSString stringWithFormat:[versionField stringValue], TETextExtrasVersionNumber]];

    // Load up the ReadMe
    readMePath = [[NSBundle bundleForClass:[self class]] pathForResource:README_FILE ofType:README_EXTENSION];
    if (readMePath) {
        [textView replaceCharactersInRange:NSMakeRange(0, [[textView string] length]) withRTF:[NSData dataWithContentsOfFile:readMePath]];
        [textView scrollRangeToVisible:NSMakeRange(0, 0)];
    }

    // And throw in the MOKit ReadMe too.
    readMePath = [[NSBundle bundleForClass:[MORegularExpression class]] pathForResource:README_FILE ofType:README_EXTENSION];
    if (readMePath) {
        [textView replaceCharactersInRange:NSMakeRange([[textView string] length], 0) withString:@"\n\n\n"];

        [textView replaceCharactersInRange:NSMakeRange([[textView string] length], 0) withRTF:[NSData dataWithContentsOfFile:readMePath]];
        [textView scrollRangeToVisible:NSMakeRange(0, 0)];
    }
}

- (void)showWindow:(id)sender {
    NSWindow *window = [self window];
    [window center];
    [super showWindow:sender];
}

@end
