// TEDirectoryListController.m
// TextExtras - Yellow Box
//
// Copyright 1996-1999, Mike Ferris.
// All rights reserved.

#import "TEDirectoryListController.h"
#import "TEOpenQuicklyController.h"

@implementation TEDirectoryListController

- (id)initWithDirectory:(NSString *)dir {
    self = [super initWithWindowNibName:@"TEDirectoryList" owner:self];
    if (self) {
        NSFileManager *fm = [NSFileManager defaultManager];
        BOOL isDirectory = NO;

        if (dir && [fm fileExistsAtPath:dir isDirectory:&isDirectory] && isDirectory) {
            directory = [dir copyWithZone:[self zone]];
        } else {
            NSLog(@"TextExtras: Directory passed to [TEDirectoryListController initWithDirectory:] does not exist or is not really a directory. ('%@')", dir);
            [self release];
            return nil;
        }
    }
    return self;
}

- (id)init {
    NSLog(@"TextExtras: TEDirectoryListController:  -init is not allowed.  Use -initWithDirectory.");
    [self release];
    return nil;
}

- (void)dealloc {
    [directory release];
    [children release];
    [super dealloc];
}

- (void)windowDidLoad {
    static NSPoint cascadePoint = {0, 0};
    NSFont *font;
    NSWindow *myWindow = [self window];
    unsigned i, c;

    [super windowDidLoad];
    
    // Remove the menu bar (only really necessary on Windows)
    [myWindow setMenu:nil];
    
    // Set up the table view.
    [tableView setHeaderView:nil];
    [tableView setTarget:self];
    [tableView setDoubleAction:@selector(tableViewDoubleAction:)];
    font = [NSFont userFixedPitchFontOfSize:0];
    [[[[tableView tableColumns] objectAtIndex:0] dataCell] setFont:font];
    [tableView setRowHeight:[font pointSize] * 1.25];

    // Set up table view data source
    children = [[[[NSFileManager defaultManager] directoryContentsAtPath:directory] sortedArrayUsingSelector:@selector(caseInsensitiveCompare:)] mutableCopyWithZone:[self zone]];
    if ((c = [children count]) > 0) {
        for (i=0; i<c; ) {
            if ([[children objectAtIndex:i] hasPrefix:@"."]) {
                [children addObject:[children objectAtIndex:i]];
                [children removeObjectAtIndex:i];
                c--;
            } else {
                i++;
            }
        }
    }
    [tableView reloadData];

    // Set up window.
    [myWindow setTitleWithRepresentedFilename:directory];
    if (NSEqualPoints(cascadePoint, NSZeroPoint)) {
        NSRect frame = [myWindow frame];
        cascadePoint = NSMakePoint(frame.origin.x, NSMaxY(frame));
    }
    cascadePoint = [myWindow cascadeTopLeftFromPoint:cascadePoint];
}

- (void)tableViewDoubleAction:(id)sender {
    // Open the file.
    unsigned selectedRow = [tableView selectedRow];
    NSString *file = [directory stringByAppendingPathComponent:[children objectAtIndex:selectedRow]];

    if (![[TEOpenQuicklyController sharedOpenQuicklyController] tryToOpenFile:file]) {
        NSBeep();
    }
}

- (int)numberOfRowsInTableView:(NSTableView *)tableView {
    return [children count];
}

- (id)tableView:(NSTableView *)tableView objectValueForTableColumn:(NSTableColumn *)tableColumn row:(int)row {
    return [children objectAtIndex:row];
}

- (void)tableView:(NSTableView *)tableView setObjectValue:(id)object forTableColumn:(NSTableColumn *)tableColumn row:(int)row {
    // No editing
    return;
}

- (void)windowWillClose:(id)sender {
    [self release];
}

@end
