/* FSSyncFinder.m created by peter on Wed 27-Oct-1999 */

/* Copyright (c)  2000, Baseview Products, Inc.	  */
/* All rights reserved.							  */
/* See the file "License" included with this	  */
/* distribution for licensing details.			  */

/* PAJ:												  */
/* Moved this code from its original location, 		  */
/* FSPopDocTextView.m.								  */
/* This is a helper class which wraps up an		  	  */
/* asynchronous query with various PB objects into    */
/* something that looks synchronous to the caller.	  */
/* Added the ability to query a single file.		  */

#import "FSSyncFinder.h"
#import "PPBAdditions.h"

@implementation FSSyncFinder

- (void)dealloc
{
	[itsResult release];
	[itsCanonicalFile release];
	[itsFindString release];
	[super dealloc];
}

- (void)fsSetCanonicalFile:(NSString *)aString
{	[itsCanonicalFile release];
	itsCanonicalFile = [aString copy];
}

- (void)fsSetFindString:(NSString *)aString
{
	[itsFindString release];
	itsFindString = [aString copy];
}

- (void)fsSetDevSource:(id)devSource
{
	[itsDevSource autorelease];
	itsDevSource = [devSource retain];
}

- (NSArray *)fsSearch
{
	id theDevServerSession;
	id theQuery;
	id theDevProject;
	NSDate *theTimeout = [NSDate dateWithTimeIntervalSinceNow:2];		//	A couple of seconds

		//	Return a dev server session [local object of class DevServerSession]
	theDevServerSession = [[NSApp delegate] getDevServer];

		//	Create a new query [distant object] DevSymbolQuery
	theQuery = [theDevServerSession newSymbolQuery];

//	We'd like to get a dev project [distant object of class DevProject]
	theDevProject = [theDevServerSession openProject:itsCanonicalFile];

		//	What to find
	[theQuery setNamePattern:itsFindString];

		//	Clear result
	[itsResult release];
	itsResult = nil;

		//	Perform the query
	if (itsDevSource)
		[itsDevSource performQuery: theQuery notifying: self];
	else
		[theDevProject performQuery:theQuery notifying:self];

		//	We wait a couple of seconds for the result
	do
	{
		[[NSRunLoop currentRunLoop]
			runMode:NSConnectionReplyMode
			beforeDate:theTimeout];
	}	while (!itsResult && [theTimeout compare:[NSDate date]]==NSOrderedDescending);

#ifdef VERBOSE
	NSLog( @"Done %@", itsResult?@"(with results)":@"(without results)" );
#endif

	return itsResult;
}

- (oneway void)requestResultedIn:(bycopy NSArray *)anArray
{
#ifdef VERBOSE
	NSLog( @"Server responded" );
#endif
	itsResult = [anArray retain];
}

@end
