// PreviewCell.m 
//
// created by Martin Wennerberg on Sun 28-Dec-1997
//
// when		who	modification

#import "PreviewCell.h"
#import "MorphDocument.h"
#import "MorphLine.h"

@implementation PreviewCell
- (void) drawInteriorWithFrame:(NSRect)cellFrame inView:(NSView *)controlView
{
    NSEnumerator *lineEnum = [[delegate morphLines] objectEnumerator];
    MorphLine	 *line;
    NSPoint		  p;

    PSgsave();
    PSscale (1, -1);
    PStranslate (0, -NSMaxY(cellFrame));
    [bitmap drawInRect:cellFrame];

    if (shouldDrawLines)
    {
        PStranslate (NSMinX(cellFrame), NSMinY(cellFrame));

        PSscale (NSWidth(cellFrame), NSHeight(cellFrame));
        PSsetlinewidth(0);

        while ((line = [lineEnum nextObject]))
        {
            p = [line startPointAtDelta:delta];
            PSmoveto(p.x, p.y);
            p = [line endPointAtDelta:delta];
            PSlineto(p.x, p.y);
        }
        [[NSColor greenColor] set];
        PSstroke();
   }
    
    PSgrestore();
}

- (void) setBitmap:(NSBitmapImageRep *)obj
{
    [bitmap autorelease];
    bitmap = [obj retain];
}

- (NSBitmapImageRep *)bitmap
{
    return bitmap;
}

- (void) setDelta:(float) val
{
    delta = val;
}

- (void) setDelegate:(id) val
{
    delegate = val;	// Don't retain the delegate.
}

- (void) setShouldDrawLines:(BOOL)yn
{
    shouldDrawLines = yn;
}
@end
