#import <AppKit/AppKit.h>

@interface MovieView : NSView
{
    IBOutlet NSControl *positionControl;
    IBOutlet NSControl *speedControl;
    IBOutlet NSButton  *playButton;
    IBOutlet NSButton  *stopButton;
    IBOutlet NSButton  *stepForwardButton;
    IBOutlet NSButton  *stepBackButton;
    IBOutlet NSButton  *rewindButton;
    IBOutlet NSButton  *fastForwardButton;
    
    NSArray	*frames;
    float    framesPerSecond;
    int		 currentFrameIndex;
    int		 direction;

    NSTimer	*timer;
}
- (void)play:(id)sender;
- (void)positionControlChanged:(id)sender;
- (void)setFrames:(id)sender;
- (void)speedControlChanged:(id)sender;
- (void)stepBackward:(id)sender;
- (void)stepForward:(id)sender;
- (void)stop:(id)sender;
- (void)rewind:sender;
- (void)fastForward:sender;

- (void)drawRect:(NSRect)rect;

- (void)animate:(id)userInfo;

-(void)updatePositionControl;
@end
