// Morpher.h
//
// Calculates morphed images. Indata is a bitmap and a number
// of control lines.
// All methods are thread safe.
//
// created by Martin Wennerberg on Sun 08-Sep-1996
//
// when		who	modification

#import <AppKit/AppKit.h>

@class NSBitmapImageRep;

struct LineCoords
{
    NSPoint start;
    NSPoint end;
};

@interface Morpher : NSObject
{
    NSBitmapImageRep	*firstBitmap;
    NSBitmapImageRep	*lastBitmap;
    NSArray				*morphLines;
    float		 progress;
}

// ----------------------------------------------------------
// public methods
// ----------------------------------------------------------

- initWithFirstBitmap:(NSBitmapImageRep *)im0
           lastBitmap:(NSBitmapImageRep *)im1
           morphLines:(NSArray *) lines;

- (void)calcMorphBitmap:(NSBitmapImageRep *) bitmap
                atDelta:(float) delta;
    // Sets the pixels of bitmap to a morphed image. Delta controls what part
    // of the morph to calculate.
    // Posts the notification morphBitmapFinished: whith self as notification
    // object.

- (float) progress;
    // Returns the current progress of the morph calculation above as
    // a number between 0.0 and 1.0.

// ----------------------------------------------------------
// protected methods
// ----------------------------------------------------------

- (void) fillDestLineCoordinates:(struct LineCoords *)lines
                           delta:(float)delta;

- (void) fillTransMatrixes:(NSAffineTransformStruct *) matrixes
             withDeltaFrom:(float) beforeDelta
                        to:(float) afterDelta;
@end
