// MorphLineInspector.m 
//
// created by Martin Wennerberg on Mon 05-Jan-1998
//
// when		who	modification

#import "MorphLineInspector.h"
#import "MorphLine.h"
#import "InspectorController.h"

@implementation MorphLineInspector
- (NSView *) view
{
    if ([super view] == nil)
        [NSBundle loadNibNamed:@"MorphLineInspector.nib" owner: self];
    
    return [super view];
}

- (BOOL) isValidInspectorForTargets:(NSArray *)inspectedObjects
{
    NSEnumerator *objEnum = [inspectedObjects objectEnumerator];
    id            obj;

    if ([inspectedObjects count] == 0)
        return NO;

    while ((obj = [objEnum nextObject]))
        if (![obj isKindOfClass:[MorphLine class]])
            return NO;
    
    return YES;
}

- (void) revert:sender
{
    NSArray		*lines = [self targets];
    MorphLine	*line = [lines lastObject];

    if (line == nil)
        return;

    [startX0Field setStringValue:[NSString stringWithFormat:@"%.2f", [line startPointAtDelta:0].x * 100.0]];
    [startY0Field setStringValue:[NSString stringWithFormat:@"%.2f", [line startPointAtDelta:0].y * 100.0]];
    [startX1Field setStringValue:[NSString stringWithFormat:@"%.2f", [line startPointAtDelta:1].x * 100.0]];
    [startY1Field setStringValue:[NSString stringWithFormat:@"%.2f", [line startPointAtDelta:1].y * 100.0]];
    [endX0Field setStringValue:[NSString stringWithFormat:@"%.2f", [line endPointAtDelta:0].x * 100.0]];
    [endY0Field setStringValue:[NSString stringWithFormat:@"%.2f", [line endPointAtDelta:0].y * 100.0]];
    [endX1Field setStringValue:[NSString stringWithFormat:@"%.2f", [line endPointAtDelta:1].x * 100.0]];
    [endY1Field setStringValue:[NSString stringWithFormat:@"%.2f", [line endPointAtDelta:1].y * 100.0]];

    [(NSMatrix *)[startX0Field controlView] setEnabled:([lines count] == 1)];
    [(NSMatrix *)[endX0Field controlView] setEnabled:([lines count] == 1)];
    
    [moveStartControl     setFloatValue:[line moveStartDelta]];    
    [moveEndControl       setFloatValue:[line moveEndDelta]];
    [dissolveStartControl setFloatValue:[line dissolveStartDelta]];
    [dissolveEndControl   setFloatValue:[line dissolveEndDelta]];
    [[self view] setNeedsDisplay:YES];
}

- (void) setValues:sender
{
    NSPoint       start0, end0, start1, end1;
    float         moveStart, moveEnd, dissolveStart, dissolveEnd;
    NSArray      *targets = [self targets];
    NSEnumerator *lineEnum = [targets objectEnumerator];
    MorphLine	 *line;
    NSCell		 *cell = nil;

    if ([sender isKindOfClass:[NSCell class]])
        cell = sender;
    else if ([sender respondsToSelector:@selector(selectedCell)])
        cell = [sender selectedCell];

    start0.x = [startX0Field floatValue] / 100.0;
    start0.y = [startY0Field floatValue] / 100.0;
    end0.x   = [endX0Field floatValue] / 100.0;
    end0.y   = [endY0Field floatValue] / 100.0;
    start1.x = [startX1Field floatValue] / 100.0;
    start1.y = [startY1Field floatValue] / 100.0;
    end1.x   = [endX1Field floatValue] / 100.0;
    end1.y   = [endY1Field floatValue] / 100.0;

    moveStart     = [moveStartControl floatValue];
    moveEnd       = [moveEndControl floatValue];
    dissolveStart = [dissolveStartControl floatValue];
    dissolveEnd   = [dissolveEndControl floatValue];

    while ((line = [lineEnum nextObject]))
    {
        if (cell == startX0Field || cell == startY0Field)
            [line setStartPoint:start0 atDelta:0];
        else if (cell == startX1Field || cell == startY1Field)
            [line setStartPoint:start1 atDelta:1];
        else if (cell == endX0Field || cell == endY0Field)
            [line setEndPoint:end0 atDelta:0];
        else if (cell == endX1Field || cell == endY1Field)
            [line setEndPoint:end1 atDelta:1];
        else if (cell == moveStartControl)
            [line setMoveStartDelta:moveStart];
        else if (cell == moveEndControl)
            [line setMoveEndDelta:moveEnd];
        else if (cell == dissolveStartControl)
            [line setDissolveStartDelta:dissolveStart];
        else if (cell == dissolveEndControl)
            [line setDissolveEndDelta:dissolveEnd];
        else
            NSLog (@"Warning:[MorphLineInspector setValues:] Unknown sender %@", sender);
    }
    [[NSNotificationQueue defaultQueue] enqueueNotification:[NSNotification notificationWithName:NOTIFICATION_SELECTION_CHANGED
                                                                                          object:[[[NSApplication sharedApplication] mainWindow] delegate]]
                                               postingStyle:NSPostWhenIdle
                                               coalesceMask:NSNotificationCoalescingOnName
                                                   forModes:nil];
}


@end
