
#import "Document.h"

@implementation Document

+ (NSSet *) readableFileTypes
{
    return nil;
}

- initWithContentsOfFile:(NSString *)file
{
    self = [super init];
    [self setFilePath:file];
    return self;
}

- init
{
    return [self initWithContentsOfFile:nil];
}

- (void) dealloc
{
	[super dealloc];
}

- (NSString *) filePath
{
    return filePath;
}

- (void) setFilePath:(NSString *)path
{
    [filePath release];
    filePath = [path retain];
    if (filePath != nil)
        [window setTitleWithRepresentedFilename:filePath];
}

- (void)show
{
	NSPoint position;
	NSWindow *mainWin;
	
	// Cascade from current window, if any.
	mainWin = [[NSApplication sharedApplication] mainWindow];
	if ( mainWin == nil )
	{
		position.x = position.y = 80.0;
	}
	else
	{
		position.x = position.y = 10.0;
		position = [mainWin cascadeTopLeftFromPoint:position];
	}
	[window cascadeTopLeftFromPoint:position];
	[window makeKeyAndOrderFront:self];
}

/* Window delegate methods */
- (void)windowWillClose:(NSNotification *)note
{
	if ([note object] != window)
            return;
        
	[window setDelegate:nil];
        // Our window is closing. Time for us to go, too.
//	[self autorelease];
}


@end
