#import "AppController.h"
#import "MorphDocument.h"
#import "XMovieDocument.h"
#import "InspectorController.h"

static NSString *curDirectory = nil;	/* Directory for open panel */

@implementation AppController

- init
{
    self = [super init];
    documentClasses = [[NSMutableArray allocWithZone:[self zone]] initWithCapacity:3];
    [documentClasses addObject:[MorphDocument class]];
    [documentClasses addObject:[XMovieDocument class]];
    return self;
}

- (void)applicationDidFinishLaunching:(NSNotification *)notification
{
    if ([[NSApplication sharedApplication] mainWindow] == nil)
        [self newDocument:nil];
}

- (void)dealloc
{
    [[NSUserDefaults standardUserDefaults] synchronize];
    [documentClasses release];
    if ( infoPanel )
        [infoPanel release];
    if ( preferencesPanel )
        [preferencesPanel release];
    [super dealloc];
}

- (NSArray *) documentClasses
{
    return documentClasses;
}

- (void) registerDocumentClass:(Class) class
{
    [documentClasses addObject:documentClasses];
}

- (void)showInfoPanel:sender
{
    if (!infoPanel)
        [NSBundle loadNibNamed:@"Info.nib" owner:self];
    [infoPanel makeKeyAndOrderFront:self];
}

- (void)showInspectorPanel:sender
{
    InspectorController *insp = [InspectorController sharedInspectorController];
    [[insp panel] orderFront:nil];
    [insp revert:nil];
}

- (void)showPreferencesPanel:sender
{
    if (!preferencesPanel)
        [NSBundle loadNibNamed:@"Preferences.nib" owner:self];
    [preferencesPanel makeKeyAndOrderFront:self];
}

- (void) newDocument:sender
{
    Document *newDocument = nil;

    if ([documentClasses count] > 0)
        newDocument = [[[documentClasses objectAtIndex:0] allocWithZone:[self zone]] init];
    [newDocument show];
}

- (void)openDocument:sender
{
    Document *newDocument;
    NSOpenPanel *openPanel;
    NSArray *filenames;
    int i, count;
    int fileNum, classNum;
    NSMutableSet	*fileTypes;
    NSString        *fileType;

    openPanel = [NSOpenPanel openPanel];
    [openPanel setCanChooseFiles:YES];
    [openPanel setAllowsMultipleSelection:YES];
    if ( curDirectory != nil )
        [openPanel setDirectory:curDirectory];

    fileTypes = [NSMutableSet setWithCapacity:10];

    for (classNum = 0; classNum < [documentClasses count]; ++classNum)
        [fileTypes unionSet:[[documentClasses objectAtIndex:classNum] readableFileTypes]];

    i = [openPanel runModalForTypes:[fileTypes allObjects]];
    if ( i != NSOKButton )
        return;
    filenames = [openPanel filenames];
    count = [filenames count];
    for ( fileNum = 0; fileNum < count; ++fileNum )
    {
        newDocument = nil;
        fileType = [[filenames objectAtIndex:fileNum] pathExtension];
        for (classNum = 0; newDocument == nil && classNum < [documentClasses count]; ++classNum)
        {
            if ([[[documentClasses objectAtIndex:classNum] readableFileTypes] containsObject:fileType])
                newDocument = [[[documentClasses objectAtIndex:classNum] alloc] initWithContentsOfFile:[filenames objectAtIndex:fileNum]];
        }
        [newDocument show];
    }
    // Keep track of the 'current directory'
    [curDirectory autorelease];
    curDirectory = [[[filenames objectAtIndex:(count - 1)]
        stringByDeletingLastPathComponent] copy];
}


/* NSApplication delegate methods */
- (BOOL)application:(NSApplication *)application
           openFile:(NSString *)filename
{
    Document *newDocument = nil;
    int classNum;
    NSString *fileType = [filename pathExtension];

    for (classNum = 0; newDocument == nil && classNum < [documentClasses count]; ++classNum)
    {
        if ([[[documentClasses objectAtIndex:classNum] readableFileTypes] containsObject:fileType])
            newDocument = [[[documentClasses objectAtIndex:classNum] alloc] initWithContentsOfFile:filename];
    }
    if ( newDocument == nil )
    {
        return NO;
    }
    [newDocument show];

    return YES;
}

@end
