/* indent:4  tabsize:8  font:fixed-width */

/*---------------------------------------------------------------------------
|----------------------------------------------------------------------------
|
|    Solitaire
|
|    A single Solitaire object acts as the central controller for the
|    Solitaire game engine.  It is the application delegate, and is 
|    responsible for finding and loading .solitaire modules.
|
|    Implementation of this class is split into Solitaire.m and 
|    SolitaireMore.m.
|
|    Thanks to Sam Streeper for BackSpace, which was a good source of 
|    sample code for this project.
|
|
|    CREDITS
|
|    Jean-Francois Veillette<jfv@iname.com>
|        -- Rework the game architecture, documentation, undo management.
|
|    Gary Ritchie<gary@uaneuro.uah.ualberta.ca>
|        -- dynamic loading, game engine, localization, documentation
|
|    Michael McCulloch<michael@hsv.tybrin.com>
|        -- artwork, CardSet preferences
|
|    Blake Stone<bstone@acs.ucalgary.ca>
|        -- original concept and Solitaire.app
|        -- CardSet classes, Klondike game
|
|----------------------------------------------------------------------------
\---------------------------------------------------------------------------*/

#import <Foundation/NSObject.h>
#import <AppKit/NSView.h>
#import <Solitaire/CardSet.h>

@class Preferences;
@class GameModule;
@class ModuleList;
@class NSMenuCell;

#define IBOutlet

@interface Solitaire : NSObject
{
    IBOutlet NSWindow* 		infoPanel;
    IBOutlet NSWindow* 		winPanel;			// default win panel
    IBOutlet NSWindow* 		settingsPanel;
    
    IBOutlet Preferences*	preferencesObject;
    IBOutlet NSBrowser*		gameSelectionBrowser;
    
    IBOutlet NSView*		commonInspector;	// do-nothing inspector
    IBOutlet NSView*		nullInspector;		// for games that wouldn't load
    NSView*					currentInspector;   // active inspector
    NSRect					inspectorFrame;         // size of inspector
    GameModule*				oldInspectorOwner;      // game controller of previous game
    IBOutlet NSBox*			invisibleInspectorBox;  // view where inspectors are shown
    
    ModuleList*				moduleList;				// list of available games

    int						realGameIndex;			// index of current game in browser

    BOOL					browserValid;           // are browser contents valid?
    BOOL					windowHasBeenDisplayed; // has the settings panel been shown?

    IBOutlet NSMenuCell* 		undoMenuCell;
    IBOutlet NSMenuCell* 		redoMenuCell;

}

- (void) applicationWillFinishLaunching:(NSNotification*)notification;
- (void) applicationDidUnhide:(NSNotification*)notification;
- (int) application:sender openFile:(NSString*)filename;
- (BOOL) applicationShouldTerminate:(id)sender;
- (void) workspaceWillPowerOff:(NSNotification*)notification;

- (void) selectGameIndex:sender;
- (void) setGameIndex;
- (void) installInspector:(NSView*)newInspector ownedBy:(GameModule*)myController;
- (GameModule*) gameController;

- (void) browser:(NSBrowser *)sender createRowsForColumn:(int)column 
	inMatrix:(NSMatrix*)matrix;
- (BOOL) browser:(NSBrowser*)sender isColumnValid:(int)column;
- (void) addCellWithString:(NSString*)str at:(int)row toMatrix:(NSMatrix*)matrix;


- (void) newGame:sender;
- (void) showRules:sender;

- (void) showInfoPanel:sender;
- (BOOL) windowShouldClose:(id)sender;

- (void) showSettingsPanel:sender;
- (void) showPreferences:sender;

- (NSColor*) backgroundColor;

- (void) win;



- getGUIForModel:model;

@end


// Stuff for building the list of games

@interface Solitaire (More)

- (void) getGameType;
- (void) setGameType:(NSString*)filename dir:(NSString*)dirname;

- (void) loadGamesFrom:(NSString*)dirname;
- (void) addGameToList:(NSString*)filename dir:(NSString*)dirname;

- (NSString*) appDirectory;

@end

