/* indent:4  tabsize:8  font:fixed-width */

/*---------------------------------------------------------------------------
|----------------------------------------------------------------------------
|
|    ModuleInfo : NSObject
|
|    Each instances of this class stores information about a .soltaire
|    module.  The ModuleList class stores these instances.
|
|    These classes based on code found in BackSpace.app by Sam Streeper.
|
|----------------------------------------------------------------------------
\---------------------------------------------------------------------------*/

#import <AppKit/AppKit.h>

@class GameModule;

@interface ModuleInfo:NSObject
{
    NSBundle*	theBundle;
    GameModule* controller;     // game controller
    NSString*  	gameName;		// localized game name
    NSString*	realName;       // nonlocalized game name
    BOOL		failed;         // true if failed to load
}

- initWithController:(GameModule*)aController name:(NSString*)aName 
	path:(NSString*)aPath;
				 
- (void) setController:(GameModule*)newController;
- (GameModule*) controller;
- (void) setFailed:(BOOL)flag;
- (BOOL) failed;
- (NSString*) gameName;
- (NSString*) realName;
- (NSString*) path;
- (NSBundle*) bundle;
- (void) dealloc;

@end

/*----------------------------------------------------------------------------
|-----------------------------------------------------------------------------
|
|    ModuleList : NSObject
|
|    Custom object to hold instances of the ModuleInfo class.
|
|    These classes based on code found in BackSpace.app by Sam Streeper.
|
|-----------------------------------------------------------------------------
\----------------------------------------------------------------------------*/

#import <Foundation/NSObject.h>

@class NSMutableArray;
@class NSString;


@interface ModuleList:NSObject
{
    NSMutableArray*	modules;
}

- init;
- (void) dealloc;
- (NSString*) nameAtIndex:(int)i;
- (NSString*) realNameAtIndex:(int)i;
- controllerAtIndex:(int)i;
- (void) sort;
- (NSString*) pathAtIndex:(int)i;

- objectAtIndex:(unsigned int)index;
- (void) addObject:anObject;
- (unsigned int) count;

@end
