/* indent:4  tabsize:8  font:fixed-width */

#import "InfoView.h"
#import <AppKit/NSImage.h>

static float dissolveFraction;

@implementation InfoView

static NSImage* _infoImage;

+ (void) initialize
{
    if (self == [InfoView class])
    {
        _infoImage = [NSImage imageNamed:@"Info"];
    }
}

- (void) mouseDown:(NSEvent*)theEvent 
{
    // switch between showing the background image and not
    showBackground = showBackground ? NO : YES;
    
    if( showBackground ) {
	int i;

	for (i=1; i<=15; i++) {
	    dissolveFraction = (float)i/15.0;
	    [self display];
	}
    } else {
        [self display];
    }
}

- (void) drawRect:(NSRect)aRect
{
    if (showBackground == YES) {
	[_infoImage dissolveToPoint:(aRect.origin) fromRect:aRect
	    fraction:dissolveFraction];
    }
}    
        

@end

