/* indent:4  tabsize:8  font:fixed-width */

#import "TenpileSuitLogic.h"
#import <Solitaire/CardPileHolder.h>
#import <Solitaire/CardPile.h>
#import "TenpileModel.h"

@implementation TenpileSuitLogic

- (BOOL) canAcceptPile:(CardPile*)aCardPile from:sender in:(CardPileHolder*)aCardPileHolder
{
    CardPile*   droppingCard = aCardPile;
    CardPile*	targetCard = [aCardPileHolder lastObject];

    if ([aCardPile count] > 1)
    {
            return NO;
    }
    
    if (targetCard)
    {
        if (([droppingCard cardSuit] == [targetCard cardSuit]) &&
                ([droppingCard cardValue] == [targetCard cardValue] + 1))
        {
            return YES;
        }
    }
    else
    {
        if ([droppingCard cardValue] == CS_ACE)
        {
            return YES;
        }
    }
    return NO;
}


- (void) acceptPile:(CardPile*)aCardPile in:(ListHolder*)aCardPileHolder
{
    [gameModel checkForWin]; 
}

@end
